/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.RColor;
import com.sun.media.content.application.x_shockwave_flash.REdge;
import com.sun.media.content.application.x_shockwave_flash.Rect;
import com.sun.media.content.application.x_shockwave_flash.SCharacter;
import com.sun.media.content.application.x_shockwave_flash.SCharacterParser;
import com.sun.media.content.application.x_shockwave_flash.SParser;
import com.sun.media.content.application.x_shockwave_flash.ScriptPlayer;
import java.awt.Point;

final class SObject {
    static final int tflagsX = 1;
    static final int tflagsY = 2;
    static final int tflagsColor = 4;
    static final int tflagsFont = 8;
    static final int tflagsHeight = 8;
    DisplayList display;
    SObject next;
    SCharacter character;
    int id;
    Matrix mat;
    Matrix devMat;
    Rect devBounds;
    boolean drawn;
    int buttonState;
    REdge edges;
    ColorTransform cx;

    SObject() {
    }

    final void ClearEdges() {
        this.edges = null;
    }

    final void BuildEdges() {
        ScriptPlayer player = this.character.player;
        if (this.edges != null || player.scriptErr != 0) {
            return;
        }
        block0 : switch (this.character.type) {
            case 0: {
                SCharacterParser parser = new SCharacterParser(player, this.character.dataPos, this.devMat, this.cx);
                parser.obj = this;
                parser.BuildEdges(true);
                break;
            }
            case 4: {
                SParser parser = new SParser();
                parser.Attach(player.script, this.character.dataPos);
                Matrix mat = Matrix.concat(parser.GetMatrix(), this.devMat);
                int nGlyphBits = parser.GetByte();
                int nAdvanceBits = parser.GetByte();
                int layer = this.id << 16;
                int n2 = 0;
                RColor color = null;
                Matrix charMat = new Matrix();
                SCharacter font = null;
                while (true) {
                    if (n2 == 0) {
                        int code = parser.GetByte();
                        if (code == 0) break block0;
                        if ((code & 8) != 0) {
                            font = player.FindCharacter(parser.GetWord());
                        }
                        if ((code & 4) != 0) {
                            color = new RColor(this.display, parser.GetColor());
                            color.order = layer++;
                            if (this.cx != null) {
                                this.cx.Apply(color);
                            }
                        }
                        if ((code & 1) != 0) {
                            charMat.tx = parser.GetSWord();
                        }
                        if ((code & 2) != 0) {
                            charMat.ty = parser.GetSWord();
                        }
                        if ((code & 8) != 0) {
                            charMat.a = charMat.d = parser.GetWord() * 64;
                        }
                        n2 = parser.GetByte();
                        parser.InitBits();
                    }
                    int g2 = parser.GetBits(nGlyphBits);
                    int advance = parser.GetSBits(nAdvanceBits);
                    if (font != null) {
                        int p = font.dataPos + 2 * g2;
                        int glyphOffset = player.script[p] & 0xFF | (player.script[p + 1] & 0xFF) << 8;
                        SCharacterParser gparser = new SCharacterParser(player, font.dataPos + glyphOffset, Matrix.concat(charMat, mat), this.cx);
                        gparser.useWinding = true;
                        gparser.obj = this;
                        gparser.nFills = 1;
                        gparser.fillIndex = new RColor[2];
                        gparser.fillIndex[1] = color;
                        gparser.BuildEdges(false);
                    }
                    charMat.tx += advance;
                    --n2;
                }
            }
        }
    }

    boolean HitTest(Point pt) {
        boolean hit = false;
        if (this.devBounds != null && this.devBounds.pointIn(pt)) {
            if (this.edges == null) {
                this.BuildEdges();
            }
            boolean colorsInited = false;
            REdge edge = this.edges;
            while (edge != null) {
                if (edge.anchor1y <= pt.y && pt.y < edge.anchor2y && edge.XRaySect(pt, 0) > 0) {
                    colorsInited = true;
                    switch (edge.fillRule) {
                        case 0: {
                            edge.color1.visible ^= 1;
                            edge.color2.visible ^= 1;
                            break;
                        }
                        case 1: {
                            edge.color1.visible ^= 1;
                            break;
                        }
                        case 2: {
                            edge.color1.visible += edge.dir;
                        }
                    }
                }
                edge = edge.nextObj;
            }
            if (colorsInited) {
                REdge edge2 = this.edges;
                while (edge2 != null) {
                    if (edge2.color1 != null) {
                        if (edge2.color1.visible != 0) {
                            hit = true;
                        }
                        edge2.color1.visible = 0;
                    }
                    if (edge2.color2 != null) {
                        if (edge2.color2.visible != 0) {
                            hit = true;
                        }
                        edge2.color2.visible = 0;
                    }
                    edge2 = edge2.nextObj;
                }
            }
        }
        return hit;
    }
}

