/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyQueryBuilder;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.UnknownCurrencyException;
import javax.money.spi.Bootstrap;
import javax.money.spi.CurrencyProviderSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;

final class DefaultMonetaryCurrenciesSingletonSpi
implements MonetaryCurrenciesSingletonSpi {
    DefaultMonetaryCurrenciesSingletonSpi() {
    }

    @Override
    public Set<CurrencyUnit> getCurrencies(CurrencyQuery query) {
        HashSet<CurrencyUnit> result = new HashSet<CurrencyUnit>();
        List<CurrencyProviderSpi> providers = this.collectProviders(query);
        for (CurrencyProviderSpi spi : providers) {
            try {
                result.addAll(spi.getCurrencies(query));
            }
            catch (Exception e) {
                Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading currency provider names for " + spi.getClass().getName(), e);
            }
        }
        return result;
    }

    private List<CurrencyProviderSpi> collectProviders(CurrencyQuery query) {
        ArrayList<CurrencyProviderSpi> result = new ArrayList<CurrencyProviderSpi>();
        if (!query.getProviderNames().isEmpty()) {
            for (String providerName : query.getProviderNames()) {
                CurrencyProviderSpi provider = this.getProvider(providerName);
                if (provider == null) {
                    Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).warning("No such currency provider found, ignoring: " + providerName);
                    continue;
                }
                result.add(provider);
            }
        } else {
            for (String providerName : this.getDefaultProviderChain()) {
                CurrencyProviderSpi provider = this.getProvider(providerName);
                if (provider == null) {
                    Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).warning("No such currency provider found, ignoring: " + providerName);
                    continue;
                }
                result.add(provider);
            }
        }
        return result;
    }

    private CurrencyProviderSpi getProvider(String providerName) {
        for (CurrencyProviderSpi provider : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            if (!provider.getProviderName().equals(providerName)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public List<String> getDefaultProviderChain() {
        ArrayList<String> provList = new ArrayList<String>();
        for (CurrencyProviderSpi currencyProviderSpi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            provList.add(currencyProviderSpi.getProviderName());
        }
        return provList;
    }

    @Override
    public Set<String> getProviderNames() {
        HashSet<String> result = new HashSet<String>();
        for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            try {
                result.add(spi.getProviderName());
            }
            catch (Exception e) {
                Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading currency provider names for " + spi.getClass().getName(), e);
            }
        }
        return result;
    }

    @Override
    public CurrencyUnit getCurrency(String currencyCode, String ... providers) {
        Objects.requireNonNull(currencyCode, "Currency Code may not be null");
        Set<CurrencyUnit> found = this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCurrencyCodes(currencyCode).setProviderNames(providers)).build());
        if (found.isEmpty()) {
            throw new UnknownCurrencyException(currencyCode);
        }
        if (found.size() > 1) {
            throw new MonetaryException("Ambiguous CurrencyUnit for code: " + currencyCode + ": " + found);
        }
        return (CurrencyUnit)found.iterator().next();
    }

    @Override
    public CurrencyUnit getCurrency(Locale country, String ... providers) {
        Set<CurrencyUnit> found = this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(country).setProviderNames(providers)).build());
        if (found.isEmpty()) {
            throw new MonetaryException("No currency unit found for locale: " + country);
        }
        if (found.size() > 1) {
            throw new MonetaryException("Ambiguous CurrencyUnit for locale: " + country + ": " + found);
        }
        return (CurrencyUnit)found.iterator().next();
    }

    @Override
    public Set<CurrencyUnit> getCurrencies(Locale locale, String ... providers) {
        return this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(locale).setProviderNames(providers)).build());
    }

    @Override
    public boolean isCurrencyAvailable(String code, String ... providers) {
        return !this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCurrencyCodes(code).setProviderNames(providers)).build()).isEmpty();
    }

    @Override
    public boolean isCurrencyAvailable(Locale locale, String ... providers) {
        return !this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(locale).setProviderNames(providers)).build()).isEmpty();
    }

    @Override
    public Set<CurrencyUnit> getCurrencies(String ... providers) {
        return this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setProviderNames(providers)).build());
    }

    @Override
    public CurrencyUnit getCurrency(CurrencyQuery query) {
        Set<CurrencyUnit> currencies = this.getCurrencies(query);
        if (currencies.isEmpty()) {
            return null;
        }
        if (currencies.size() == 1) {
            return currencies.iterator().next();
        }
        throw new MonetaryException("Ambiguous request for CurrencyUnit: " + query + ", found: " + currencies);
    }
}

