/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryException;
import javax.money.MonetaryRounding;
import javax.money.RoundingContext;
import javax.money.RoundingContextBuilder;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryRoundingsSingletonSpi;
import javax.money.spi.RoundingProviderSpi;

final class DefaultMonetaryRoundingsSingletonSpi
implements MonetaryRoundingsSingletonSpi {
    private static final MonetaryRounding DEFAULT_ROUNDING = new DefaultCurrencyRounding();

    DefaultMonetaryRoundingsSingletonSpi() {
    }

    public RoundingQueryBuilder createRoundingQueryBuilder() {
        throw new IllegalStateException("No MonetaryRoundingsSingletonSpi registered.");
    }

    @Override
    public MonetaryRounding getDefaultRounding() {
        return DEFAULT_ROUNDING;
    }

    @Override
    public Collection<MonetaryRounding> getRoundings(RoundingQuery query) {
        ArrayList<MonetaryRounding> result = new ArrayList<MonetaryRounding>();
        List<String> providerNames = query.getProviderNames();
        if (providerNames == null || providerNames.isEmpty()) {
            providerNames = this.getDefaultProviderChain();
        }
        Collection<RoundingProviderSpi> allProviders = Bootstrap.getServices(RoundingProviderSpi.class);
        for (String providerName : providerNames) {
            for (RoundingProviderSpi curProv : allProviders) {
                if (!providerName.equals(curProv.getProviderName())) continue;
                try {
                    MonetaryRounding r = curProv.getRounding(query);
                    if (r == null) continue;
                    result.add(r);
                }
                catch (Exception e) {
                    Logger.getLogger(DefaultMonetaryRoundingsSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + curProv, e);
                }
            }
        }
        return result;
    }

    @Override
    public Set<String> getProviderNames() {
        HashSet<String> result = new HashSet<String>();
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                result.add(prov.getProviderName());
            }
            catch (Exception e) {
                Logger.getLogger(DefaultMonetaryRoundingsSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
            }
        }
        return result;
    }

    @Override
    public List<String> getDefaultProviderChain() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getProviderNames());
        Collections.sort(result);
        return result;
    }

    @Override
    public Set<String> getRoundingNames(String ... providers) {
        HashSet<String> result = new HashSet<String>();
        String[] providerNames = providers;
        if (providerNames.length == 0) {
            providerNames = this.getDefaultProviderChain().toArray(new String[this.getDefaultProviderChain().size()]);
        }
        for (String providerName : providerNames) {
            for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
                try {
                    if (!prov.getProviderName().equals(providerName) && !prov.getProviderName().matches(providerName)) continue;
                    result.addAll(prov.getRoundingNames());
                }
                catch (Exception e) {
                    Logger.getLogger(DefaultMonetaryRoundingsSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
                }
            }
        }
        return result;
    }

    @Override
    public MonetaryRounding getRounding(CurrencyUnit currencyUnit, String ... providers) {
        MonetaryRounding op = this.getRounding(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setCurrency(currencyUnit).build());
        if (op == null) {
            throw new MonetaryException("No rounding provided for CurrencyUnit: " + currencyUnit.getCurrencyCode());
        }
        return op;
    }

    @Override
    public MonetaryRounding getRounding(String roundingName, String ... providers) {
        MonetaryRounding op = this.getRounding(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setRoundingName(roundingName).build());
        if (op == null) {
            throw new MonetaryException("No rounding provided with rounding name: " + roundingName);
        }
        return op;
    }

    @Override
    public MonetaryRounding getRounding(RoundingQuery query) {
        Collection<MonetaryRounding> roundings = this.getRoundings(query);
        if (roundings.isEmpty()) {
            return null;
        }
        return roundings.iterator().next();
    }

    @Override
    public boolean isRoundingAvailable(RoundingQuery query) {
        return !this.getRoundings(query).isEmpty();
    }

    @Override
    public boolean isRoundingAvailable(String roundingId, String ... providers) {
        return this.isRoundingAvailable(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setRoundingName(roundingId).build());
    }

    @Override
    public boolean isRoundingAvailable(CurrencyUnit currencyUnit, String ... providers) {
        return this.isRoundingAvailable(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setCurrency(currencyUnit).build());
    }

    private static final class DefaultCurrencyRounding
    implements MonetaryRounding,
    Serializable {
        private static final RoundingContext ROUNDING_CONTEXT = RoundingContextBuilder.of("default", "default").build();

        private DefaultCurrencyRounding() {
        }

        @Override
        public MonetaryAmount apply(MonetaryAmount amount) {
            MonetaryRounding r = Monetary.getRounding(amount.getCurrency(), new String[0]);
            return r.apply(amount);
        }

        @Override
        public RoundingContext getRoundingContext() {
            return ROUNDING_CONTEXT;
        }
    }
}

