/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.DefaultMonetaryCurrenciesSingletonSpi;
import javax.money.DefaultMonetaryRoundingsSingletonSpi;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryException;
import javax.money.MonetaryRounding;
import javax.money.RoundingQuery;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountsSingletonQuerySpi;
import javax.money.spi.MonetaryAmountsSingletonSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;
import javax.money.spi.MonetaryRoundingsSingletonSpi;

public final class Monetary {
    private static MonetaryCurrenciesSingletonSpi monetaryCurrenciesSpi() {
        try {
            MonetaryCurrenciesSingletonSpi spi = Bootstrap.getService(MonetaryCurrenciesSingletonSpi.class);
            if (spi == null) {
                spi = new DefaultMonetaryCurrenciesSingletonSpi();
            }
            return spi;
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.INFO, "Failed to load MonetaryCurrenciesSingletonSpi, using default.", e);
            return new DefaultMonetaryCurrenciesSingletonSpi();
        }
    }

    private static MonetaryAmountsSingletonSpi monetaryAmountsSingletonSpi() {
        MonetaryAmountsSingletonSpi spi = null;
        try {
            spi = Bootstrap.getService(MonetaryAmountsSingletonSpi.class);
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryAmountsSingletonSpi.", e);
        }
        if (spi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return spi;
    }

    private static MonetaryAmountsSingletonQuerySpi monetaryAmountsSingletonQuerySpi() {
        MonetaryAmountsSingletonQuerySpi spi = null;
        try {
            spi = Bootstrap.getService(MonetaryAmountsSingletonQuerySpi.class);
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryAmountsSingletonQuerySpi.", e);
        }
        if (spi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.");
        }
        return spi;
    }

    private static MonetaryRoundingsSingletonSpi monetaryRoundingsSpi() {
        try {
            MonetaryRoundingsSingletonSpi spi = Bootstrap.getService(MonetaryRoundingsSingletonSpi.class);
            if (spi == null) {
                spi = new DefaultMonetaryRoundingsSingletonSpi();
            }
            return spi;
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryCurrenciesSingletonSpi, using default.", e);
            return new DefaultMonetaryRoundingsSingletonSpi();
        }
    }

    private Monetary() {
    }

    public static CurrencyUnit getCurrency(String currencyCode, String ... providers) {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return Monetary.monetaryCurrenciesSpi().getCurrency(currencyCode, providers);
    }

    public static CurrencyUnit getCurrency(Locale locale, String ... providers) {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return Monetary.monetaryCurrenciesSpi().getCurrency(locale, providers);
    }

    public static Set<CurrencyUnit> getCurrencies(Locale locale, String ... providers) {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return Monetary.monetaryCurrenciesSpi().getCurrencies(locale, providers);
    }

    public static boolean isCurrencyAvailable(String code, String ... providers) {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new IllegalStateException("No Monetary Spi loaded.");
        }
        return Monetary.monetaryCurrenciesSpi().isCurrencyAvailable(code, providers);
    }

    public static boolean isCurrencyAvailable(Locale locale, String ... providers) {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new IllegalStateException("No Monetary Spi loaded.");
        }
        return Monetary.monetaryCurrenciesSpi().isCurrencyAvailable(locale, providers);
    }

    public static Collection<CurrencyUnit> getCurrencies(String ... providers) {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return Monetary.monetaryCurrenciesSpi().getCurrencies(providers);
    }

    public static CurrencyUnit getCurrency(CurrencyQuery query) {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return Monetary.monetaryCurrenciesSpi().getCurrency(query);
    }

    public static Collection<CurrencyUnit> getCurrencies(CurrencyQuery query) {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return Monetary.monetaryCurrenciesSpi().getCurrencies(query);
    }

    public static Set<String> getCurrencyProviderNames() {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return Monetary.monetaryCurrenciesSpi().getProviderNames();
    }

    public static List<String> getDefaultCurrencyProviderChain() {
        if (Monetary.monetaryCurrenciesSpi() == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return Monetary.monetaryCurrenciesSpi().getDefaultProviderChain();
    }

    public static <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        MonetaryAmountsSingletonSpi spi = Monetary.monetaryAmountsSingletonSpi();
        if (spi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        MonetaryAmountFactory<T> factory = spi.getAmountFactory(amountType);
        if (factory == null) {
            throw new MonetaryException("No AmountFactory available for type: " + amountType.getName());
        }
        return factory;
    }

    public static MonetaryAmountFactory<?> getDefaultAmountFactory() {
        MonetaryAmountsSingletonSpi spi = Monetary.monetaryAmountsSingletonSpi();
        if (spi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return spi.getDefaultAmountFactory();
    }

    public static Collection<MonetaryAmountFactory<?>> getAmountFactories() {
        if (Monetary.monetaryAmountsSingletonSpi() == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryAmountsSingletonSpi().getAmountFactories();
    }

    public static Collection<Class<? extends MonetaryAmount>> getAmountTypes() {
        if (Monetary.monetaryAmountsSingletonSpi() == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryAmountsSingletonSpi().getAmountTypes();
    }

    public static Class<? extends MonetaryAmount> getDefaultAmountType() {
        if (Monetary.monetaryAmountsSingletonSpi() == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryAmountsSingletonSpi().getDefaultAmountType();
    }

    public static MonetaryAmountFactory getAmountFactory(MonetaryAmountFactoryQuery query) {
        if (Monetary.monetaryAmountsSingletonQuerySpi() == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryAmountsSingletonQuerySpi().getAmountFactory(query);
    }

    public static Collection<MonetaryAmountFactory<?>> getAmountFactories(MonetaryAmountFactoryQuery query) {
        if (Monetary.monetaryAmountsSingletonQuerySpi() == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryAmountsSingletonQuerySpi().getAmountFactories(query);
    }

    public static boolean isAvailable(MonetaryAmountFactoryQuery query) {
        if (Monetary.monetaryAmountsSingletonQuerySpi() == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryAmountsSingletonQuerySpi().isAvailable(query);
    }

    public static MonetaryRounding getDefaultRounding() {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().getDefaultRounding();
    }

    public static MonetaryRounding getRounding(CurrencyUnit currencyUnit, String ... providers) {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().getRounding(currencyUnit, providers);
    }

    public static MonetaryRounding getRounding(String roundingName, String ... providers) {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().getRounding(roundingName, providers);
    }

    public static MonetaryRounding getRounding(RoundingQuery roundingQuery) {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().getRounding(roundingQuery);
    }

    public static boolean isRoundingAvailable(String roundingName, String ... providers) {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().isRoundingAvailable(roundingName, providers);
    }

    public static boolean isRoundingAvailable(CurrencyUnit currencyUnit, String ... providers) {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().isRoundingAvailable(currencyUnit, providers);
    }

    public static boolean isRoundingAvailable(RoundingQuery roundingQuery) {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().isRoundingAvailable(roundingQuery);
    }

    public static Collection<MonetaryRounding> getRoundings(RoundingQuery roundingQuery) {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().getRoundings(roundingQuery);
    }

    public static Set<String> getRoundingNames(String ... providers) {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().getRoundingNames(providers);
    }

    public static Set<String> getRoundingProviderNames() {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().getProviderNames();
    }

    public static List<String> getDefaultRoundingProviderChain() {
        if (Monetary.monetaryRoundingsSpi() == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return Monetary.monetaryRoundingsSpi().getDefaultProviderChain();
    }
}

