/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.io.Serializable;
import javax.money.AbstractContext;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryContextBuilder;

public final class MonetaryContext
extends AbstractContext
implements Serializable {
    static final String AMOUNT_TYPE = "amountType";
    private static final String PRECISION = "precision";
    private static final String FIXED_SCALE = "fixedScale";
    private static final String MAX_SCALE = "maxScale";

    MonetaryContext(MonetaryContextBuilder builder) {
        super(builder);
    }

    public int getPrecision() {
        Integer val = this.getInt(PRECISION);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public boolean isFixedScale() {
        Boolean val = this.getBoolean(FIXED_SCALE);
        if (val == null) {
            return false;
        }
        return val;
    }

    public int getMaxScale() {
        Integer val = this.getInt(MAX_SCALE);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public Class<? extends MonetaryAmount> getAmountType() {
        Class clazz = this.get(AMOUNT_TYPE, Class.class);
        return clazz.asSubclass(MonetaryAmount.class);
    }

    public static MonetaryContext from(MonetaryAmountFactoryQuery monetaryAmountFactoryQuery, Class<? extends MonetaryAmount> amountClass) {
        return ((MonetaryContextBuilder)MonetaryContextBuilder.of(amountClass).importContext(monetaryAmountFactoryQuery)).build();
    }

    public static MonetaryContext from(MonetaryContext monetaryContext, Class<? extends MonetaryAmount> amountClass) {
        return ((MonetaryContextBuilder)MonetaryContextBuilder.of(amountClass).importContext(monetaryContext)).build();
    }

    public MonetaryContextBuilder toBuilder() {
        return MonetaryContextBuilder.of(this);
    }
}

