/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.money.AbstractQueryBuilder;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.convert.ConversionQuery;
import javax.money.convert.RateType;

public final class ConversionQueryBuilder
extends AbstractQueryBuilder<ConversionQueryBuilder, ConversionQuery> {
    private ConversionQueryBuilder() {
    }

    public ConversionQueryBuilder setRateTypes(RateType ... rateTypes) {
        return (ConversionQueryBuilder)this.set("Query.rateTypes", new HashSet<RateType>(Arrays.asList(rateTypes)));
    }

    public ConversionQueryBuilder setRateTypes(Set<RateType> rateTypes) {
        return (ConversionQueryBuilder)this.set("Query.rateTypes", rateTypes);
    }

    public ConversionQueryBuilder setBaseCurrency(CurrencyUnit currency) {
        return (ConversionQueryBuilder)this.set("Query.baseCurrency", currency);
    }

    public ConversionQueryBuilder setBaseCurrency(String currencyCode) {
        return this.setBaseCurrency(Monetary.getCurrency(currencyCode, new String[0]));
    }

    public ConversionQueryBuilder setTermCurrency(CurrencyUnit currency) {
        return (ConversionQueryBuilder)this.set("Query.termCurrency", currency);
    }

    public ConversionQueryBuilder setTermCurrency(String currencyCode) {
        return this.setTermCurrency(Monetary.getCurrency(currencyCode, new String[0]));
    }

    @Override
    public ConversionQuery build() {
        return new ConversionQuery(this);
    }

    public static ConversionQueryBuilder of() {
        return new ConversionQueryBuilder();
    }

    public static ConversionQueryBuilder of(ConversionQuery query) {
        return (ConversionQueryBuilder)new ConversionQueryBuilder().importContext(query);
    }
}

