/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryException;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ExchangeRateProviderSupplier;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryConversionsSingletonSpi;

public final class MonetaryConversions {
    private static MonetaryConversionsSingletonSpi getMonetaryConversionsSpi() {
        return Optional.ofNullable(Bootstrap.getService(MonetaryConversionsSingletonSpi.class)).orElseThrow(() -> new MonetaryException("No MonetaryConversionsSingletonSpi loaded, query functionality is not available."));
    }

    private MonetaryConversions() {
    }

    public static CurrencyConversion getConversion(CurrencyUnit termCurrency, String ... providers) {
        Objects.requireNonNull(providers);
        Objects.requireNonNull(termCurrency);
        if (providers.length == 0) {
            return MonetaryConversions.getMonetaryConversionsSpi().getConversion(((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(termCurrency).setProviderNames(MonetaryConversions.getDefaultConversionProviderChain())).build());
        }
        return MonetaryConversions.getMonetaryConversionsSpi().getConversion(((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(termCurrency).setProviderNames(providers)).build());
    }

    public static CurrencyConversion getConversion(String termCurrencyCode, String ... providers) {
        Objects.requireNonNull(termCurrencyCode, "Term currency code may not be null");
        return MonetaryConversions.getConversion(Monetary.getCurrency(termCurrencyCode, new String[0]), providers);
    }

    public static CurrencyConversion getConversion(ConversionQuery conversionQuery) {
        return MonetaryConversions.getMonetaryConversionsSpi().getConversion(conversionQuery);
    }

    public static boolean isConversionAvailable(ConversionQuery conversionQuery) {
        return MonetaryConversions.getMonetaryConversionsSpi().isConversionAvailable(conversionQuery);
    }

    public static boolean isConversionAvailable(String currencyCode, String ... providers) {
        return MonetaryConversions.getMonetaryConversionsSpi().isConversionAvailable(Monetary.getCurrency(currencyCode, new String[0]), providers);
    }

    public static boolean isConversionAvailable(CurrencyUnit termCurrency, String ... providers) {
        return MonetaryConversions.getMonetaryConversionsSpi().isConversionAvailable(termCurrency, providers);
    }

    public static ExchangeRateProvider getExchangeRateProvider(String ... providers) {
        if (providers.length == 0) {
            List<String> defaultProviderChain = MonetaryConversions.getDefaultConversionProviderChain();
            return MonetaryConversions.getMonetaryConversionsSpi().getExchangeRateProvider(((ConversionQueryBuilder)ConversionQueryBuilder.of().setProviderNames(defaultProviderChain.toArray(new String[defaultProviderChain.size()]))).build());
        }
        ExchangeRateProvider provider = MonetaryConversions.getMonetaryConversionsSpi().getExchangeRateProvider(((ConversionQueryBuilder)ConversionQueryBuilder.of().setProviderNames(providers)).build());
        return Optional.ofNullable(provider).orElseThrow(() -> new MonetaryException("No such rate provider: " + Arrays.toString(providers)));
    }

    public static ExchangeRateProvider getExchangeRateProvider(ExchangeRateProviderSupplier provider, ExchangeRateProviderSupplier ... providers) {
        ArrayList<ExchangeRateProviderSupplier> suppliers = new ArrayList<ExchangeRateProviderSupplier>();
        suppliers.add(Objects.requireNonNull(provider));
        suppliers.addAll(Arrays.asList(providers));
        String[] array = (String[])suppliers.stream().map(ExchangeRateProviderSupplier::get).toArray(String[]::new);
        return MonetaryConversions.getExchangeRateProvider(array);
    }

    public static ExchangeRateProvider getExchangeRateProvider(ConversionQuery conversionQuery) {
        return MonetaryConversions.getMonetaryConversionsSpi().getExchangeRateProvider(conversionQuery);
    }

    public static boolean isExchangeRateProviderAvailable(ConversionQuery conversionQuery) {
        return MonetaryConversions.getMonetaryConversionsSpi().isExchangeRateProviderAvailable(conversionQuery);
    }

    public static Collection<String> getConversionProviderNames() {
        Collection<String> providers = MonetaryConversions.getMonetaryConversionsSpi().getProviderNames();
        if (Objects.isNull(providers)) {
            Logger.getLogger(MonetaryConversions.class.getName()).warning("No supported rate/conversion providers returned by SPI: " + MonetaryConversions.getMonetaryConversionsSpi().getClass().getName());
            return Collections.emptySet();
        }
        return providers;
    }

    public static List<String> getDefaultConversionProviderChain() {
        List<String> defaultChain = MonetaryConversions.getMonetaryConversionsSpi().getDefaultProviderChain();
        Objects.requireNonNull(defaultChain, "No default provider chain provided by SPI: " + MonetaryConversions.getMonetaryConversionsSpi().getClass().getName());
        return defaultChain;
    }
}

