/*
 * Decompiled with CFR 0.152.
 */
package javax.websocket;

import javax.websocket.ClientContainer;
import javax.websocket.ServerContainer;

public class ContainerProvider {
    private static String SERVER_CLASSNAME_PROPERTYNAME = "webocket.servercontainer.classname";
    private static String CLIENT_CLASSNAME_PROPERTYNAME = "webocket.clientcontainer.classname";

    public static ServerContainer getServerContainer() {
        return (ServerContainer)ContainerProvider.loadImplementation(SERVER_CLASSNAME_PROPERTYNAME);
    }

    public static ClientContainer getClientContainer() {
        return (ClientContainer)ContainerProvider.loadImplementation(CLIENT_CLASSNAME_PROPERTYNAME);
    }

    private static Object loadImplementation(String name) {
        String clName = System.getProperty(name);
        if (clName != null) {
            try {
                Class<?> c = Class.forName(name);
                return c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("cannot find system property: " + name);
    }
}

