/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.freemarker;

import com.sun.script.freemarker.FreeMarkerScriptEngineFactory;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class FreeMarkerScriptEngine
extends AbstractScriptEngine {
    public static final String STRING_OUTPUT_MODE = "com.sun.script.freemarker.stringOut";
    public static final String FREEMARKER_CONFIG = "com.sun.script.freemarker.config";
    public static final String FREEMARKER_PROPERTIES = "com.sun.script.freemarker.properties";
    public static final String FREEMARKER_TEMPLATE_DIR = "com.sun.script.freemarker.template.dir";
    private volatile ScriptEngineFactory factory;
    private volatile Configuration conf;

    public FreeMarkerScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    public FreeMarkerScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval((Reader)new StringReader(str), ctx);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        ctx.setAttribute("context", ctx, 100);
        this.initFreeMarkerConfiguration(ctx);
        String fileName = FreeMarkerScriptEngine.getFilename(ctx);
        boolean outputAsString = FreeMarkerScriptEngine.isStringOutputMode(ctx);
        Writer out = outputAsString ? new StringWriter() : ctx.getWriter();
        Bindings engineScope = ctx.getBindings(100);
        try {
            Template template = new Template(fileName, reader, this.conf);
            template.process((Object)engineScope, out);
            out.flush();
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        return outputAsString ? out.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            FreeMarkerScriptEngine freeMarkerScriptEngine = this;
            synchronized (freeMarkerScriptEngine) {
                if (this.factory == null) {
                    this.factory = new FreeMarkerScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private static String getFilename(ScriptContext ctx) {
        Object fileName = ctx.getAttribute("javax.script.filename");
        return fileName != null ? fileName.toString() : "<unknown>";
    }

    private static boolean isStringOutputMode(ScriptContext ctx) {
        Object flag = ctx.getAttribute(STRING_OUTPUT_MODE);
        if (flag != null) {
            return flag.equals(Boolean.TRUE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFreeMarkerConfiguration(ScriptContext ctx) {
        if (this.conf == null) {
            FreeMarkerScriptEngine freeMarkerScriptEngine = this;
            synchronized (freeMarkerScriptEngine) {
                if (this.conf != null) {
                    return;
                }
                Object cfg = ctx.getAttribute(FREEMARKER_CONFIG);
                if (cfg instanceof Configuration) {
                    this.conf = (Configuration)cfg;
                    return;
                }
                Configuration tmpConf = new Configuration();
                try {
                    FreeMarkerScriptEngine.initConfProps(tmpConf, ctx);
                    FreeMarkerScriptEngine.initTemplateDir(tmpConf, ctx);
                }
                catch (RuntimeException rexp) {
                    throw rexp;
                }
                catch (Exception exp) {
                    throw new RuntimeException(exp);
                }
                this.conf = tmpConf;
            }
        }
    }

    private static void initConfProps(Configuration conf, ScriptContext ctx) {
        try {
            Properties props = null;
            Object tmp = ctx.getAttribute(FREEMARKER_PROPERTIES);
            if (props instanceof Properties) {
                props = (Properties)tmp;
            } else {
                File propsFile;
                String propsName = System.getProperty(FREEMARKER_PROPERTIES);
                if (propsName != null && (propsFile = new File(propsName)).exists() && propsFile.canRead()) {
                    props = new Properties();
                    props.load(new FileInputStream(propsFile));
                }
            }
            if (props != null) {
                Set<Object> keys = props.keySet();
                for (Object obj : keys) {
                    if (!(obj instanceof String)) continue;
                    String key = (String)obj;
                    try {
                        conf.setSetting(key, props.get(key).toString());
                    }
                    catch (TemplateException te) {}
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private static void initTemplateDir(Configuration conf, ScriptContext ctx) {
        try {
            Object tmp = ctx.getAttribute(FREEMARKER_TEMPLATE_DIR);
            String dirName = tmp != null ? tmp.toString() : ((tmp = System.getProperty(FREEMARKER_TEMPLATE_DIR)) == null ? "." : tmp.toString());
            File dir = new File(dirName);
            if (dir.exists() && dir.isDirectory()) {
                conf.setDirectoryForTemplateLoading(dir);
            }
        }
        catch (IOException exp) {
            throw new RuntimeException(exp);
        }
    }
}

