/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.core;

import android.gov.nist.core.GenericObject;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Host
extends GenericObject {
    private static boolean stripAddressScopeZones = false;
    private static final long serialVersionUID = -7233564517978323344L;
    protected static final int HOSTNAME = 1;
    protected static final int IPV4ADDRESS = 2;
    protected static final int IPV6ADDRESS = 3;
    protected String hostname;
    protected int addressType;
    private InetAddress inetAddress;

    public Host() {
        this.addressType = 1;
    }

    public Host(String hostName) throws IllegalArgumentException {
        if (hostName == null) {
            throw new IllegalArgumentException("null host name");
        }
        this.setHost(hostName, 2);
    }

    public Host(String name, int addrType) {
        this.setHost(name, addrType);
    }

    @Override
    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder encode(StringBuilder buffer) {
        if (this.addressType == 3 && !Host.isIPv6Reference(this.hostname)) {
            buffer.append('[').append(this.hostname).append(']');
        } else {
            buffer.append(this.hostname);
        }
        return buffer;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Host otherHost = (Host)obj;
        return otherHost.hostname.equals(this.hostname);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getAddress() {
        return this.hostname;
    }

    public String getIpAddress() {
        String rawIpAddress;
        block12: {
            rawIpAddress = null;
            if (this.hostname == null) {
                return null;
            }
            if (this.addressType == 1) {
                try {
                    if (this.inetAddress == null) {
                        this.inetAddress = InetAddress.getByName(this.hostname);
                    }
                    rawIpAddress = this.inetAddress.getHostAddress();
                }
                catch (UnknownHostException ex) {
                    this.dbgPrint("Could not resolve hostname " + ex);
                }
            } else if (this.addressType == 3) {
                try {
                    String ipv6FullForm = this.getInetAddress().toString();
                    int slashIndex = ipv6FullForm.indexOf("/");
                    if (slashIndex != -1) {
                        ipv6FullForm = ipv6FullForm.substring(++slashIndex, ipv6FullForm.length());
                    }
                    if (this.hostname.startsWith("[")) {
                        rawIpAddress = '[' + ipv6FullForm + ']';
                        break block12;
                    }
                    rawIpAddress = ipv6FullForm;
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            } else {
                rawIpAddress = this.hostname;
            }
        }
        return rawIpAddress;
    }

    public void setHostname(String h) {
        this.setHost(h, 1);
    }

    public void setHostAddress(String address) {
        this.setHost(address, 2);
    }

    private void setHost(String host, int type) {
        this.inetAddress = null;
        this.addressType = this.isIPv6Address(host) ? 3 : type;
        if (host != null) {
            this.hostname = host.trim();
            if (this.addressType == 1) {
                this.hostname = this.hostname.toLowerCase();
            }
            int zoneStart = -1;
            if (this.addressType == 3 && stripAddressScopeZones && (zoneStart = this.hostname.indexOf(37)) != -1) {
                this.hostname = this.hostname.substring(0, zoneStart);
                if (this.hostname.startsWith("[") && !this.hostname.endsWith("]")) {
                    this.hostname = this.hostname + ']';
                }
            }
        }
    }

    public void setAddress(String address) {
        this.setHostAddress(address);
    }

    public boolean isHostname() {
        return this.addressType == 1;
    }

    public boolean isIPAddress() {
        return this.addressType != 1;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.hostname == null) {
            return null;
        }
        if (this.inetAddress != null) {
            return this.inetAddress;
        }
        this.inetAddress = InetAddress.getByName(this.hostname);
        return this.inetAddress;
    }

    private boolean isIPv6Address(String address) {
        return address != null && address.indexOf(58) != -1;
    }

    public static boolean isIPv6Reference(String address) {
        return address.charAt(0) == '[' && address.charAt(address.length() - 1) == ']';
    }

    public int hashCode() {
        return this.getHostname().hashCode();
    }

    static {
        stripAddressScopeZones = Boolean.getBoolean("android.gov.nist.core.STRIP_ADDR_SCOPES");
    }
}

