/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.core;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.Debug;
import android.gov.nist.core.StackLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;

public class LogWriter
implements StackLogger {
    private Logger logger;
    private String stackName;
    private String logFileName = null;
    private volatile boolean needsLogging = false;
    private int lineCount;
    protected int traceLevel = 0;
    private String buildTimeStamp;
    private Properties configurationProperties;

    @Override
    public void logStackTrace() {
        this.logStackTrace(32);
    }

    @Override
    public void logStackTrace(int traceLevel) {
        if (this.needsLogging) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceElement[] ste = new Exception().getStackTrace();
            for (int i = 1; i < ste.length; ++i) {
                String callFrame = "[" + ste[i].getFileName() + ":" + ste[i].getLineNumber() + "]";
                pw.print(callFrame);
            }
            pw.close();
            String stackTrace = sw.getBuffer().toString();
            Level level = this.getLevel(traceLevel);
            Priority priority = this.getLogPriority();
            if (level.isGreaterOrEqual(priority)) {
                this.logger.log((Priority)level, (Object)stackTrace);
            }
        }
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addAppender(Appender appender) {
        this.logger.addAppender(appender);
    }

    @Override
    public void logException(Throwable ex) {
        if (this.needsLogging) {
            this.getLogger().error((Object)ex.getMessage(), ex);
        }
    }

    private void countLines(String message) {
        char[] chars = message.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            ++this.lineCount;
        }
    }

    private String enhanceMessage(String message) {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        StackTraceElement elem = stackTrace[3];
        String className = elem.getClassName();
        String methodName = elem.getMethodName();
        String fileName = elem.getFileName();
        int lineNumber = elem.getLineNumber();
        String newMessage = className + "." + methodName + "(" + fileName + ":" + lineNumber + ") [" + message + "]";
        return newMessage;
    }

    @Override
    public void logDebug(String message) {
        if (this.needsLogging) {
            String newMessage = this.enhanceMessage(message);
            if (this.lineCount == 0) {
                this.getLogger().debug((Object)("BUILD TIMESTAMP = " + this.buildTimeStamp));
                this.getLogger().debug((Object)("Config Propeties = " + this.configurationProperties));
            }
            this.countLines(newMessage);
            this.getLogger().debug((Object)newMessage);
        }
    }

    @Override
    public void logDebug(String message, Exception ex) {
        if (this.needsLogging) {
            String newMessage = this.enhanceMessage(message);
            if (this.lineCount == 0) {
                this.getLogger().debug((Object)("BUILD TIMESTAMP = " + this.buildTimeStamp));
                this.getLogger().debug((Object)("Config Propeties = " + this.configurationProperties));
            }
            this.countLines(newMessage);
            this.getLogger().debug((Object)newMessage, (Throwable)ex);
        }
    }

    @Override
    public void logTrace(String message) {
        if (this.needsLogging) {
            String newMessage = this.enhanceMessage(message);
            if (this.lineCount == 0) {
                this.getLogger().debug((Object)("BUILD TIMESTAMP = " + this.buildTimeStamp));
                this.getLogger().debug((Object)("Config Propeties = " + this.configurationProperties));
            }
            this.countLines(newMessage);
            this.getLogger().trace((Object)newMessage);
        }
    }

    private void setTraceLevel(int level) {
        this.traceLevel = level;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public void logFatalError(String message) {
        Logger logger = this.getLogger();
        String newMsg = this.enhanceMessage(message);
        this.countLines(newMsg);
        logger.fatal((Object)newMsg);
    }

    @Override
    public void logError(String message) {
        Logger logger = this.getLogger();
        String newMsg = this.enhanceMessage(message);
        this.countLines(newMsg);
        logger.error((Object)newMsg);
    }

    @Override
    public void setStackProperties(Properties configurationProperties) {
        block30: {
            this.configurationProperties = configurationProperties;
            String logLevel = configurationProperties.getProperty("android.gov.nist.javax.sip.TRACE_LEVEL");
            this.logFileName = configurationProperties.getProperty("android.gov.nist.javax.sip.DEBUG_LOG");
            this.stackName = configurationProperties.getProperty("android.javax.sip.STACK_NAME");
            String category = configurationProperties.getProperty("android.gov.nist.javax.sip.LOG4J_LOGGER_NAME", this.stackName);
            this.logger = Logger.getLogger((String)category);
            if (logLevel != null) {
                if (logLevel.equals("LOG4J")) {
                    CommonLogger.useLegacyLogger = false;
                } else {
                    try {
                        int ll = 0;
                        if (logLevel.equals("TRACE")) {
                            ll = 32;
                            Debug.debug = true;
                            Debug.setStackLogger(this);
                        } else if (logLevel.equals("DEBUG")) {
                            ll = 32;
                        } else if (logLevel.equals("INFO")) {
                            ll = 16;
                        } else if (logLevel.equals("ERROR")) {
                            ll = 4;
                        } else if (logLevel.equals("NONE") || logLevel.equals("OFF")) {
                            ll = 0;
                        } else {
                            ll = Integer.parseInt(logLevel);
                            if (ll > 32) {
                                Debug.debug = true;
                                Debug.setStackLogger(this);
                            }
                        }
                        this.setTraceLevel(ll);
                        this.needsLogging = true;
                        if (this.traceLevel == 32) {
                            this.logger.setLevel(Level.DEBUG);
                        } else if (this.traceLevel == 16) {
                            this.logger.setLevel(Level.INFO);
                        } else if (this.traceLevel == 4) {
                            this.logger.setLevel(Level.ERROR);
                        } else if (this.traceLevel == 0) {
                            this.logger.setLevel(Level.OFF);
                            this.needsLogging = false;
                        }
                        if (!this.needsLogging || this.logFileName == null) break block30;
                        boolean overwrite = Boolean.valueOf(configurationProperties.getProperty("android.gov.nist.javax.sip.DEBUG_LOG_OVERWRITE"));
                        FileAppender fa = null;
                        try {
                            fa = new FileAppender((Layout)new SimpleLayout(), this.logFileName, !overwrite);
                        }
                        catch (FileNotFoundException fnf) {
                            File logfile = new File(this.logFileName);
                            logfile.getParentFile().mkdirs();
                            logfile.delete();
                            try {
                                fa = new FileAppender((Layout)new SimpleLayout(), this.logFileName);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        if (fa != null) {
                            this.logger.addAppender(fa);
                        }
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                        System.err.println("LogWriter: Bad integer " + logLevel);
                        System.err.println("logging dislabled ");
                        this.needsLogging = false;
                    }
                }
            } else {
                this.needsLogging = false;
            }
        }
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.needsLogging;
    }

    @Override
    public boolean isLoggingEnabled(int logLevel) {
        return this.needsLogging && logLevel <= this.traceLevel;
    }

    @Override
    public void logError(String message, Exception ex) {
        Logger logger = this.getLogger();
        logger.error((Object)message, (Throwable)ex);
    }

    @Override
    public void logWarning(String string) {
        this.getLogger().warn((Object)string);
    }

    @Override
    public void logInfo(String string) {
        this.getLogger().info((Object)string);
    }

    @Override
    public void disableLogging() {
        this.needsLogging = false;
    }

    @Override
    public void enableLogging() {
        this.needsLogging = true;
    }

    @Override
    public void setBuildTimeStamp(String buildTimeStamp) {
        this.buildTimeStamp = buildTimeStamp;
    }

    public Priority getLogPriority() {
        if (this.traceLevel == 16) {
            return Priority.INFO;
        }
        if (this.traceLevel == 4) {
            return Priority.ERROR;
        }
        if (this.traceLevel == 32) {
            return Priority.DEBUG;
        }
        if (this.traceLevel == 64) {
            return Priority.DEBUG;
        }
        return Priority.FATAL;
    }

    public Level getLevel(int traceLevel) {
        if (traceLevel == 16) {
            return Level.INFO;
        }
        if (traceLevel == 4) {
            return Level.ERROR;
        }
        if (traceLevel == 32) {
            return Level.DEBUG;
        }
        if (traceLevel == 64) {
            return Level.ALL;
        }
        return Level.OFF;
    }

    @Override
    public String getLoggerName() {
        if (this.logger != null) {
            return this.logger.getName();
        }
        return null;
    }
}

