/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.core;

import android.gov.nist.core.GenericObject;
import android.gov.nist.core.NameValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NameValueList
implements Serializable,
Cloneable,
Map<String, NameValue> {
    private static final long serialVersionUID = -6998271876574260243L;
    private Map<String, NameValue> hmap;
    private String separator = ";";
    private boolean sync = false;

    public NameValueList() {
    }

    public NameValueList(boolean sync) {
        this.sync = sync;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    public StringBuilder encode(StringBuilder buffer) {
        Iterator<NameValue> iterator;
        if (!this.isEmpty() && (iterator = this.iterator()).hasNext()) {
            while (true) {
                NameValue obj;
                if ((obj = iterator.next()) instanceof GenericObject) {
                    GenericObject gobj = obj;
                    gobj.encode(buffer);
                } else {
                    buffer.append(obj.toString());
                }
                if (!iterator.hasNext()) break;
                buffer.append(this.separator);
            }
        }
        return buffer;
    }

    public String toString() {
        return this.encode();
    }

    public void set(NameValue nv) {
        this.put(nv.getName().toLowerCase(), nv);
    }

    public void set(String name, Object value) {
        NameValue nameValue = new NameValue(name, value);
        this.put(name.toLowerCase(), nameValue);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        NameValueList other = (NameValueList)otherObject;
        if (this.size() != this.size()) {
            return false;
        }
        Iterator<String> li = this.getNames();
        while (li.hasNext()) {
            String key = li.next();
            NameValue nv1 = this.getNameValue(key);
            NameValue nv2 = other.get(key);
            if (nv2 == null) {
                return false;
            }
            if (nv2.equals(nv1)) continue;
            return false;
        }
        return true;
    }

    public Object getValue(String name) {
        return this.getValue(name, true);
    }

    public Object getValue(String name, boolean stripQuotes) {
        NameValue nv = this.getNameValue(name.toLowerCase());
        if (nv != null) {
            return nv.getValueAsObject(stripQuotes);
        }
        return null;
    }

    public NameValue getNameValue(String name) {
        if (this.hmap == null) {
            return null;
        }
        return this.hmap.get(name.toLowerCase());
    }

    public boolean hasNameValue(String name) {
        return this.containsKey(name.toLowerCase());
    }

    public boolean delete(String name) {
        String lcName = name.toLowerCase();
        if (this.containsKey(lcName)) {
            this.remove(lcName);
            return true;
        }
        return false;
    }

    public Object clone() {
        NameValueList retval = new NameValueList();
        retval.setSeparator(this.separator);
        if (this.hmap != null) {
            Iterator<NameValue> it = this.iterator();
            while (it.hasNext()) {
                retval.set((NameValue)it.next().clone());
            }
        }
        return retval;
    }

    @Override
    public int size() {
        if (this.hmap == null) {
            return 0;
        }
        return this.hmap.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.hmap == null) {
            return true;
        }
        return this.hmap.isEmpty();
    }

    public Iterator<NameValue> iterator() {
        return this.getMap().values().iterator();
    }

    public Iterator<String> getNames() {
        return this.getMap().keySet().iterator();
    }

    public String getParameter(String name) {
        return this.getParameter(name, true);
    }

    public String getParameter(String name, boolean stripQuotes) {
        Object val = this.getValue(name, stripQuotes);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    @Override
    public void clear() {
        if (this.hmap != null) {
            this.hmap.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.hmap == null) {
            return false;
        }
        return this.hmap.containsKey(key.toString().toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.hmap == null) {
            return false;
        }
        return this.hmap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, NameValue>> entrySet() {
        if (this.hmap == null) {
            return new HashSet<Map.Entry<String, NameValue>>();
        }
        return this.hmap.entrySet();
    }

    @Override
    public NameValue get(Object key) {
        if (this.hmap == null) {
            return null;
        }
        return this.hmap.get(key.toString().toLowerCase());
    }

    @Override
    public Set<String> keySet() {
        if (this.hmap == null) {
            return new HashSet<String>();
        }
        return this.hmap.keySet();
    }

    @Override
    public NameValue put(String name, NameValue nameValue) {
        return this.getMap().put(name, nameValue);
    }

    @Override
    public void putAll(Map<? extends String, ? extends NameValue> map) {
        this.getMap().putAll(map);
    }

    @Override
    public NameValue remove(Object key) {
        if (this.hmap == null) {
            return null;
        }
        return this.getMap().remove(key.toString().toLowerCase());
    }

    @Override
    public Collection<NameValue> values() {
        return this.getMap().values();
    }

    @Override
    public int hashCode() {
        return this.getMap().keySet().hashCode();
    }

    protected Map<String, NameValue> getMap() {
        if (this.hmap == null) {
            this.hmap = this.sync ? new ConcurrentHashMap<String, NameValue>(0) : new LinkedHashMap<String, NameValue>(0);
        }
        return this.hmap;
    }
}

