/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.core;

import android.gov.nist.core.Debug;
import android.gov.nist.core.LexerCore;
import android.gov.nist.core.NameValue;
import android.gov.nist.core.Token;
import java.text.ParseException;

public abstract class ParserCore {
    public static final boolean debug = Debug.parserDebug;
    static int nesting_level;
    protected LexerCore lexer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NameValue nameValue(char separator) throws ParseException {
        if (debug) {
            this.dbg_enter("nameValue");
        }
        try {
            this.lexer.match(4095);
            Token name = this.lexer.getNextToken();
            this.lexer.SPorHT();
            try {
                boolean quoted = false;
                char la = this.lexer.lookAhead(0);
                if (la == separator) {
                    Token value;
                    this.lexer.consume(1);
                    this.lexer.SPorHT();
                    String str = null;
                    boolean isFlag = false;
                    char c = this.lexer.lookAhead(0);
                    if (c == '\"') {
                        str = this.lexer.quotedString();
                        quoted = true;
                    } else if (c == '[') {
                        this.lexer.match(4100);
                        value = this.lexer.getNextToken();
                        str = value.tokenValue;
                        if (str == null) {
                            str = "";
                            isFlag = true;
                        }
                    } else {
                        this.lexer.match(4095);
                        value = this.lexer.getNextToken();
                        str = value.tokenValue;
                        if (str == null) {
                            str = "";
                            isFlag = true;
                        }
                    }
                    NameValue nv = new NameValue(name.tokenValue, str, isFlag);
                    if (quoted) {
                        nv.setQuotedValue();
                    }
                    NameValue nameValue = nv;
                    return nameValue;
                }
                NameValue nameValue = new NameValue(name.tokenValue, "", true);
                return nameValue;
            }
            catch (ParseException ex) {
                NameValue nameValue = new NameValue(name.tokenValue, null, false);
                return nameValue;
            }
        }
        finally {
            if (debug) {
                this.dbg_leave("nameValue");
            }
        }
    }

    protected void dbg_enter(String rule) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nesting_level; ++i) {
            stringBuilder.append(">");
        }
        if (debug) {
            System.out.println(stringBuilder + rule + "\nlexer buffer = \n" + this.lexer.getRest());
        }
        ++nesting_level;
    }

    protected void dbg_leave(String rule) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nesting_level; ++i) {
            stringBuilder.append("<");
        }
        if (debug) {
            System.out.println(stringBuilder + rule + "\nlexer buffer = \n" + this.lexer.getRest());
        }
        --nesting_level;
    }

    protected NameValue nameValue() throws ParseException {
        return this.nameValue('=');
    }

    protected void peekLine(String rule) {
        if (debug) {
            Debug.println(rule + " " + this.lexer.peekLine());
        }
    }
}

