/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.core;

import java.text.ParseException;
import java.util.Vector;

public class StringTokenizer {
    protected char[] buffer;
    protected int bufferLen;
    protected int ptr;
    protected int savedPtr;

    protected StringTokenizer() {
    }

    public StringTokenizer(String buffer) {
        this.buffer = buffer.toCharArray();
        this.bufferLen = buffer.length();
        this.ptr = 0;
    }

    public String nextToken() {
        int startIdx = this.ptr;
        while (this.ptr < this.bufferLen) {
            char c = this.buffer[this.ptr];
            ++this.ptr;
            if (c != '\n') continue;
            break;
        }
        return String.valueOf(this.buffer, startIdx, this.ptr - startIdx);
    }

    public boolean hasMoreChars() {
        return this.ptr < this.bufferLen;
    }

    public static boolean isHexDigit(char ch) {
        return ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f' || StringTokenizer.isDigit(ch);
    }

    public static boolean isAlpha(char ch) {
        if (ch <= '\u007f') {
            return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
        }
        return Character.isLowerCase(ch) || Character.isUpperCase(ch);
    }

    public static boolean isDigit(char ch) {
        if (ch <= '\u007f') {
            return ch <= '9' && ch >= '0';
        }
        return Character.isDigit(ch);
    }

    public static boolean isAlphaDigit(char ch) {
        if (ch <= '\u007f') {
            return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch <= '9' && ch >= '0';
        }
        return Character.isLowerCase(ch) || Character.isUpperCase(ch) || Character.isDigit(ch);
    }

    public String getLine() {
        int startIdx = this.ptr;
        while (this.ptr < this.bufferLen && this.buffer[this.ptr] != '\n') {
            ++this.ptr;
        }
        if (this.ptr < this.bufferLen && this.buffer[this.ptr] == '\n') {
            ++this.ptr;
        }
        return String.valueOf(this.buffer, startIdx, this.ptr - startIdx);
    }

    public String peekLine() {
        int curPos = this.ptr;
        String retval = this.getLine();
        this.ptr = curPos;
        return retval;
    }

    public char lookAhead() throws ParseException {
        return this.lookAhead(0);
    }

    public char lookAhead(int k) throws ParseException {
        try {
            return this.buffer[this.ptr + k];
        }
        catch (IndexOutOfBoundsException e) {
            return '\u0000';
        }
    }

    public char getNextChar() throws ParseException {
        if (this.ptr >= this.bufferLen) {
            throw new ParseException(this.buffer + " getNextChar: End of buffer", this.ptr);
        }
        return this.buffer[this.ptr++];
    }

    public void consume() {
        this.ptr = this.savedPtr;
    }

    public void consume(int k) {
        this.ptr += k;
    }

    public Vector<String> getLines() {
        Vector<String> result = new Vector<String>();
        while (this.hasMoreChars()) {
            String line = this.getLine();
            result.addElement(line);
        }
        return result;
    }

    public String getNextToken(char delim) throws ParseException {
        char la;
        int startIdx = this.ptr;
        while ((la = this.lookAhead(0)) != delim) {
            if (la == '\u0000') {
                throw new ParseException("EOL reached", 0);
            }
            this.consume(1);
        }
        return String.valueOf(this.buffer, startIdx, this.ptr - startIdx);
    }

    public static String getSDPFieldName(String line) {
        if (line == null) {
            return null;
        }
        String fieldName = null;
        try {
            int begin = line.indexOf("=");
            fieldName = line.substring(0, begin);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return fieldName;
    }
}

