/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.core.net;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import android.gov.nist.core.net.SecurityManagerProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class DefaultSecurityManagerProvider
implements SecurityManagerProvider {
    private static final StackLogger logger = CommonLogger.getLogger(DefaultSecurityManagerProvider.class);
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;

    @Override
    public void init(Properties properties) throws GeneralSecurityException, IOException {
        String algorithm;
        String trustStoreType;
        String keyStoreFilename = properties.getProperty("javax.net.ssl.keyStore");
        String keyStorePassword = properties.getProperty("javax.net.ssl.keyStorePassword");
        String keyStoreType = properties.getProperty("javax.net.ssl.keyStoreType");
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
            logger.logWarning("Using default keystore type " + keyStoreType);
        }
        if (keyStoreFilename == null || keyStorePassword == null) {
            logger.logWarning("TLS server settings will be inactive - TLS key store will use JVM defaults keyStoreType=" + keyStoreType + " javax.net.ssl.keyStore=" + keyStoreFilename + " javax.net.ssl.keyStorePassword=" + (keyStorePassword == null ? null : "***"));
        }
        String trustStoreFilename = properties.getProperty("javax.net.ssl.trustStore");
        String trustStorePassword = properties.getProperty("javax.net.ssl.trustStorePassword");
        if (trustStorePassword == null) {
            logger.logInfo("javax.net.ssl.trustStorePassword is null, using the password passed through javax.net.ssl.keyStorePassword");
            trustStorePassword = keyStorePassword;
        }
        if ((trustStoreType = properties.getProperty("javax.net.ssl.trustStoreType")) == null) {
            trustStoreType = KeyStore.getDefaultType();
            logger.logWarning("Using default truststore type " + trustStoreType);
        }
        if (trustStoreFilename == null || trustStorePassword == null) {
            logger.logWarning("TLS trust settings will be inactive - TLS trust store will use JVM defaults. trustStoreType=" + trustStoreType + " javax.net.ssl.trustStore=" + trustStoreFilename + " javax.net.ssl.trustStorePassword=" + (trustStorePassword == null ? null : "***"));
        }
        if ((algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm")) == null) {
            algorithm = "SunX509";
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SecurityManagerProvider " + this.getClass().getCanonicalName() + " will use algorithm " + algorithm);
        }
        this.keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
        if (keyStoreFilename != null) {
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(new FileInputStream(new File(keyStoreFilename)), keyStorePassword.toCharArray());
            this.keyManagerFactory.init(ks, keyStorePassword.toCharArray());
        } else {
            this.keyManagerFactory.init(null, null);
        }
        this.trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
        if (trustStoreFilename != null) {
            KeyStore ts = KeyStore.getInstance(trustStoreType);
            ts.load(new FileInputStream(new File(trustStoreFilename)), trustStorePassword.toCharArray());
            this.trustManagerFactory.init(ts);
        } else {
            this.trustManagerFactory.init((KeyStore)null);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("TLS settings OK. SecurityManagerProvider " + this.getClass().getCanonicalName() + " initialized.");
        }
    }

    @Override
    public KeyManager[] getKeyManagers(boolean client) {
        if (this.keyManagerFactory == null) {
            return null;
        }
        return this.keyManagerFactory.getKeyManagers();
    }

    @Override
    public TrustManager[] getTrustManagers(boolean client) {
        if (this.trustManagerFactory == null) {
            return null;
        }
        return this.trustManagerFactory.getTrustManagers();
    }
}

