/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.core.net;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import android.gov.nist.core.net.NetworkLayer;
import android.gov.nist.javax.sip.SipStackImpl;
import android.gov.nist.javax.sip.stack.ClientAuthType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslNetworkLayer
implements NetworkLayer {
    private static StackLogger logger = CommonLogger.getLogger(SslNetworkLayer.class);
    private SSLSocketFactory sslSocketFactory;
    private SSLServerSocketFactory sslServerSocketFactory;
    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("checkClientTrusted : Not validating certs " + certs + " authType " + authType);
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("checkServerTrusted : Not validating certs " + certs + " authType " + authType);
            }
        }
    }};

    public SslNetworkLayer(SipStackImpl sipStack, String trustStoreFile, String keyStoreFile, char[] keyStorePassword, char[] trustStorePassword, String keyStoreType, String trustStoreType) throws GeneralSecurityException, FileNotFoundException, IOException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(algorithm);
        KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(algorithm);
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextInt();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType != null ? keyStoreType : KeyStore.getDefaultType());
        KeyStore trustStore = KeyStore.getInstance(trustStoreType != null ? trustStoreType : KeyStore.getDefaultType());
        keyStore.load(new FileInputStream(keyStoreFile), keyStorePassword);
        trustStore.load(new FileInputStream(trustStoreFile), trustStorePassword);
        tmFactory.init(trustStore);
        kmFactory.init(keyStore, keyStorePassword);
        if (sipStack.getClientAuth() == ClientAuthType.DisabledAll) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("ClientAuth " + (Object)((Object)sipStack.getClientAuth()) + " bypassing all cert validations");
            }
            sslContext.init(null, this.trustAllCerts, secureRandom);
        } else {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("ClientAuth " + (Object)((Object)sipStack.getClientAuth()));
            }
            sslContext.init(kmFactory.getKeyManagers(), tmFactory.getTrustManagers(), secureRandom);
        }
        this.sslServerSocketFactory = sslContext.getServerSocketFactory();
        this.sslSocketFactory = sslContext.getSocketFactory();
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(port, backlog, bindAddress);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return new Socket(address, port);
    }

    @Override
    public DatagramSocket createDatagramSocket() throws SocketException {
        return new DatagramSocket();
    }

    @Override
    public DatagramSocket createDatagramSocket(int port, InetAddress laddr) throws SocketException {
        return new DatagramSocket(port, laddr);
    }

    @Override
    public SSLServerSocket createSSLServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog, bindAddress);
    }

    @Override
    public SSLSocket createSSLSocket(InetAddress address, int port) throws IOException {
        return this.createSSLSocket(address, port, null);
    }

    @Override
    public SSLSocket createSSLSocket(InetAddress address, int port, InetAddress myAddress) throws IOException {
        SSLSocket sock = (SSLSocket)this.sslSocketFactory.createSocket();
        if (myAddress != null) {
            sock.bind(new InetSocketAddress(myAddress, 0));
        }
        try {
            sock.connect(new InetSocketAddress(address, port), 8000);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectException("Socket timeout error (8sec)" + address + ":" + port);
        }
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress myAddress) throws IOException {
        if (myAddress != null) {
            Socket sock = new Socket();
            sock.bind(new InetSocketAddress(myAddress, 0));
            try {
                sock.connect(new InetSocketAddress(address, port), 8000);
            }
            catch (SocketTimeoutException e) {
                throw new ConnectException("Socket timeout error (8sec)" + address + ":" + port);
            }
            return sock;
        }
        Socket sock = new Socket();
        try {
            sock.connect(new InetSocketAddress(address, port), 8000);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectException("Socket timeout error (8sec)" + address + ":" + port);
        }
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress myAddress, int myPort) throws IOException {
        if (myAddress != null) {
            Socket sock = new Socket();
            sock.bind(new InetSocketAddress(myAddress, 0));
            try {
                sock.connect(new InetSocketAddress(address, port), 8000);
            }
            catch (SocketTimeoutException e) {
                throw new ConnectException("Socket timeout error (8sec)" + address + ":" + port);
            }
            return sock;
        }
        Socket sock = new Socket();
        if (myPort != 0) {
            sock.bind(new InetSocketAddress(port));
        }
        try {
            sock.connect(new InetSocketAddress(address, port), 8000);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectException("Socket timeout error (8sec)" + address + ":" + port);
        }
        return sock;
    }

    @Override
    public void setSipStack(SipStackImpl sipStackImpl) {
    }
}

