/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sdp.fields;

import android.gov.nist.javax.sdp.fields.SDPField;
import android.javax.sdp.Media;
import android.javax.sdp.SdpException;
import android.javax.sdp.SdpParseException;
import java.util.Vector;

public class MediaField
extends SDPField
implements Media {
    protected String media;
    protected int port;
    protected int nports;
    protected String proto;
    protected Vector formats = new Vector();

    public MediaField() {
        super("m=");
    }

    public String getMedia() {
        return this.media;
    }

    public int getPort() {
        return this.port;
    }

    public int getNports() {
        return this.nports;
    }

    public String getProto() {
        return this.proto;
    }

    public Vector getFormats() {
        return this.formats;
    }

    public void setMedia(String m) {
        this.media = m;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setNports(int n) {
        this.nports = n;
    }

    public void setProto(String p) {
        this.proto = p;
    }

    public void setFormats(Vector formats) {
        this.formats = formats;
    }

    @Override
    public String getMediaType() throws SdpParseException {
        return this.getMedia();
    }

    @Override
    public void setMediaType(String mediaType) throws SdpException {
        if (mediaType == null) {
            throw new SdpException("The mediaType is null");
        }
        this.setMedia(mediaType);
    }

    @Override
    public int getMediaPort() throws SdpParseException {
        return this.getPort();
    }

    @Override
    public void setMediaPort(int port) throws SdpException {
        if (port < 0) {
            throw new SdpException("The port is < 0");
        }
        this.setPort(port);
    }

    @Override
    public int getPortCount() throws SdpParseException {
        return this.getNports();
    }

    @Override
    public void setPortCount(int portCount) throws SdpException {
        if (portCount < 0) {
            throw new SdpException("The port count is < 0");
        }
        this.setNports(portCount);
    }

    @Override
    public String getProtocol() throws SdpParseException {
        return this.getProto();
    }

    @Override
    public void setProtocol(String protocol) throws SdpException {
        if (protocol == null) {
            throw new SdpException("The protocol is null");
        }
        this.setProto(protocol);
    }

    @Override
    public Vector getMediaFormats(boolean create) throws SdpParseException {
        if (!create && this.formats.size() == 0) {
            return null;
        }
        return this.formats;
    }

    @Override
    public void setMediaFormats(Vector mediaFormats) throws SdpException {
        if (mediaFormats == null) {
            throw new SdpException("The mediaFormats is null");
        }
        this.formats = mediaFormats;
    }

    private String encodeFormats() {
        StringBuilder retval = new StringBuilder(3 * this.formats.size());
        for (int i = 0; i < this.formats.size(); ++i) {
            retval.append(this.formats.elementAt(i));
            if (i >= this.formats.size() - 1) continue;
            retval.append(" ");
        }
        return retval.toString();
    }

    @Override
    public String encode() {
        String encoded_string = "m=";
        if (this.media != null) {
            encoded_string = encoded_string + this.media.toLowerCase() + " " + this.port;
        }
        if (this.nports > 1) {
            encoded_string = encoded_string + "/" + this.nports;
        }
        if (this.proto != null) {
            encoded_string = encoded_string + " " + this.proto;
        }
        if (this.formats != null) {
            encoded_string = encoded_string + " " + this.encodeFormats();
        }
        encoded_string = encoded_string + "\r\n";
        return encoded_string;
    }

    @Override
    public Object clone() {
        MediaField retval = (MediaField)super.clone();
        if (this.formats != null) {
            retval.formats = (Vector)this.formats.clone();
        }
        return retval;
    }
}

