/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sdp.fields;

import android.gov.nist.javax.sdp.fields.SDPField;
import android.javax.sdp.SdpException;
import android.javax.sdp.SdpFactory;
import android.javax.sdp.SdpParseException;
import android.javax.sdp.Time;
import java.util.Date;

public class TimeField
extends SDPField
implements Time {
    protected long startTime;
    protected long stopTime;

    public TimeField() {
        super("t=");
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    @Override
    public Date getStart() throws SdpParseException {
        return SdpFactory.getDateFromNtp(this.startTime);
    }

    @Override
    public Date getStop() throws SdpParseException {
        return SdpFactory.getDateFromNtp(this.stopTime);
    }

    @Override
    public void setStop(Date stop) throws SdpException {
        if (stop == null) {
            throw new SdpException("The date is null");
        }
        this.stopTime = SdpFactory.getNtpTime(stop);
    }

    @Override
    public void setStart(Date start) throws SdpException {
        if (start == null) {
            throw new SdpException("The date is null");
        }
        this.startTime = SdpFactory.getNtpTime(start);
    }

    @Override
    public boolean getTypedTime() {
        return false;
    }

    @Override
    public void setTypedTime(boolean typedTime) {
    }

    @Override
    public boolean isZero() {
        return this.getStartTime() == 0L && this.getStopTime() == 0L;
    }

    @Override
    public void setZero() {
        this.setStopTime(0L);
        this.setStartTime(0L);
    }

    @Override
    public String encode() {
        return "t=" + this.startTime + " " + this.stopTime + "\r\n";
    }
}

