/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sdp.fields;

import android.gov.nist.javax.sdp.fields.SDPField;
import android.gov.nist.javax.sdp.fields.SDPObjectList;
import android.gov.nist.javax.sdp.fields.ZoneAdjustment;
import android.javax.sdp.SdpException;
import android.javax.sdp.SdpParseException;
import android.javax.sdp.TimeZoneAdjustment;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;

public class ZoneField
extends SDPField
implements TimeZoneAdjustment {
    protected SDPObjectList zoneAdjustments = new SDPObjectList();

    public ZoneField() {
        super("z=");
    }

    public void addZoneAdjustment(ZoneAdjustment za) {
        this.zoneAdjustments.add(za);
    }

    public SDPObjectList getZoneAdjustments() {
        return this.zoneAdjustments;
    }

    @Override
    public String encode() {
        StringBuilder retval = new StringBuilder("z=");
        ListIterator li = this.zoneAdjustments.listIterator();
        int num = 0;
        while (li.hasNext()) {
            ZoneAdjustment za = (ZoneAdjustment)li.next();
            if (num > 0) {
                retval.append(" ");
            }
            retval.append(za.encode());
            ++num;
        }
        retval.append("\r\n");
        return retval.toString();
    }

    @Override
    public Hashtable getZoneAdjustments(boolean create) throws SdpParseException {
        ZoneAdjustment zone;
        Hashtable<Date, Integer> result = new Hashtable<Date, Integer>();
        SDPObjectList zoneAdjustments = this.getZoneAdjustments();
        if (zoneAdjustments == null) {
            if (create) {
                return new Hashtable();
            }
            return null;
        }
        while ((zone = (ZoneAdjustment)zoneAdjustments.next()) != null) {
            Long l = zone.getTime();
            Integer time = Integer.valueOf(l.toString());
            Date date = new Date(zone.getTime());
            result.put(date, time);
        }
        return result;
    }

    @Override
    public void setZoneAdjustments(Hashtable map) throws SdpException {
        if (map == null) {
            throw new SdpException("The map is null");
        }
        Enumeration e = map.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Date) {
                Date date = (Date)o;
                ZoneAdjustment zone = new ZoneAdjustment();
                zone.setTime(date.getTime());
                this.addZoneAdjustment(zone);
                continue;
            }
            throw new SdpException("The map is not well-formated ");
        }
    }

    @Override
    public void setTypedTime(boolean typedTime) {
    }

    @Override
    public boolean getTypedTime() {
        return false;
    }

    @Override
    public Object clone() {
        ZoneField retval = (ZoneField)super.clone();
        if (this.zoneAdjustments != null) {
            retval.zoneAdjustments = (SDPObjectList)this.zoneAdjustments.clone();
        }
        return retval;
    }
}

