/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.Host;
import android.gov.nist.core.HostPort;
import android.gov.nist.core.InternalErrorHandler;
import android.gov.nist.core.StackLogger;
import android.gov.nist.javax.sip.ListeningPointExt;
import android.gov.nist.javax.sip.SipProviderImpl;
import android.gov.nist.javax.sip.SipStackImpl;
import android.gov.nist.javax.sip.address.AddressImpl;
import android.gov.nist.javax.sip.address.SipUri;
import android.gov.nist.javax.sip.header.Contact;
import android.gov.nist.javax.sip.header.Via;
import android.gov.nist.javax.sip.message.SIPRequest;
import android.gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import android.gov.nist.javax.sip.stack.MessageChannel;
import android.gov.nist.javax.sip.stack.MessageProcessor;
import android.javax.sip.ListeningPoint;
import android.javax.sip.SipStack;
import android.javax.sip.header.ContactHeader;
import android.javax.sip.header.ViaHeader;
import java.io.IOException;
import java.text.ParseException;

public class ListeningPointImpl
implements ListeningPoint,
ListeningPointExt {
    private static StackLogger logger = CommonLogger.getLogger(ListeningPointImpl.class);
    protected String transport;
    int port;
    protected MessageProcessor messageProcessor;
    protected SipProviderImpl sipProvider;
    protected SipStackImpl sipStack;

    public static String makeKey(String host, int port, String transport) {
        return (host + ":" + port + "/" + transport).toLowerCase();
    }

    protected String getKey() {
        return ListeningPointImpl.makeKey(this.getIPAddress(), this.port, this.transport);
    }

    public void setSipProvider(SipProviderImpl sipProviderImpl) {
        this.sipProvider = sipProviderImpl;
    }

    public void removeSipProvider() {
        this.sipProvider = null;
    }

    protected ListeningPointImpl(SipStack sipStack, int port, String transport) {
        this.sipStack = (SipStackImpl)sipStack;
        this.port = port;
        this.transport = transport;
    }

    public Object clone() {
        ListeningPointImpl lip = new ListeningPointImpl(this.sipStack, this.port, null);
        lip.sipStack = this.sipStack;
        return lip;
    }

    @Override
    public int getPort() {
        return this.messageProcessor.getPort();
    }

    @Override
    public String getTransport() {
        return this.messageProcessor.getTransport();
    }

    public SipProviderImpl getProvider() {
        return this.sipProvider;
    }

    @Override
    public String getIPAddress() {
        return this.messageProcessor.getIpAddress().getHostAddress();
    }

    @Override
    public void setSentBy(String sentBy) throws ParseException {
        this.messageProcessor.setSentBy(sentBy);
    }

    @Override
    public String getSentBy() {
        return this.messageProcessor.getSentBy();
    }

    public boolean isSentBySet() {
        return this.messageProcessor.isSentBySet();
    }

    public Via getViaHeader() {
        return this.messageProcessor.getViaHeader();
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    @Override
    public ContactHeader createContactHeader() {
        try {
            String ipAddress = this.getIPAddress();
            int port = this.getPort();
            SipUri sipURI = new SipUri();
            sipURI.setHost(ipAddress);
            sipURI.setPort(port);
            sipURI.setTransportParam(this.transport);
            Contact contact = new Contact();
            AddressImpl address = new AddressImpl();
            address.setURI(sipURI);
            contact.setAddress(address);
            return contact;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException("Unexpected exception", logger);
            return null;
        }
    }

    @Override
    public void sendHeartbeat(String ipAddress, int port) throws IOException {
        ConnectionOrientedMessageChannel connectionOrientedMessageChannel;
        long keepaliveTimeout;
        if (!this.sipStack.isAlive()) {
            return;
        }
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(new Host(ipAddress));
        targetHostPort.setPort(port);
        MessageChannel messageChannel = this.messageProcessor.createMessageChannel(targetHostPort);
        SIPRequest siprequest = new SIPRequest();
        siprequest.setNullRequest();
        if (messageChannel instanceof ConnectionOrientedMessageChannel && (keepaliveTimeout = (connectionOrientedMessageChannel = (ConnectionOrientedMessageChannel)messageChannel).getKeepAliveTimeout()) > 0L) {
            connectionOrientedMessageChannel.rescheduleKeepAliveTimeout(keepaliveTimeout);
        }
        messageChannel.sendMessage(siprequest);
    }

    @Override
    public ViaHeader createViaHeader() {
        return this.getViaHeader();
    }
}

