/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.LogWriter;
import android.gov.nist.core.ServerLogger;
import android.gov.nist.core.StackLogger;
import android.gov.nist.core.ThreadAuditor;
import android.gov.nist.core.net.AddressResolver;
import android.gov.nist.core.net.DefaultSecurityManagerProvider;
import android.gov.nist.core.net.NetworkLayer;
import android.gov.nist.core.net.SecurityManagerProvider;
import android.gov.nist.core.net.SslNetworkLayer;
import android.gov.nist.javax.sip.EventScanner;
import android.gov.nist.javax.sip.ListeningPointImpl;
import android.gov.nist.javax.sip.LogRecordFactory;
import android.gov.nist.javax.sip.MergedSystemProperties;
import android.gov.nist.javax.sip.NistSipMessageFactoryImpl;
import android.gov.nist.javax.sip.ReleaseReferencesStrategy;
import android.gov.nist.javax.sip.SipProviderImpl;
import android.gov.nist.javax.sip.SipStackExt;
import android.gov.nist.javax.sip.TlsSecurityPolicy;
import android.gov.nist.javax.sip.clientauthutils.AccountManager;
import android.gov.nist.javax.sip.clientauthutils.AuthenticationHelper;
import android.gov.nist.javax.sip.clientauthutils.AuthenticationHelperImpl;
import android.gov.nist.javax.sip.clientauthutils.SecureAccountManager;
import android.gov.nist.javax.sip.parser.MessageParserFactory;
import android.gov.nist.javax.sip.parser.PostParseExecutorServices;
import android.gov.nist.javax.sip.parser.StringMsgParser;
import android.gov.nist.javax.sip.parser.StringMsgParserFactory;
import android.gov.nist.javax.sip.stack.ByteBufferFactory;
import android.gov.nist.javax.sip.stack.ClientAuthType;
import android.gov.nist.javax.sip.stack.DefaultMessageLogFactory;
import android.gov.nist.javax.sip.stack.DefaultRouter;
import android.gov.nist.javax.sip.stack.MessageProcessor;
import android.gov.nist.javax.sip.stack.MessageProcessorFactory;
import android.gov.nist.javax.sip.stack.NIOMode;
import android.gov.nist.javax.sip.stack.OIOMessageProcessorFactory;
import android.gov.nist.javax.sip.stack.SIPEventInterceptor;
import android.gov.nist.javax.sip.stack.SIPMessageValve;
import android.gov.nist.javax.sip.stack.SIPTransactionStack;
import android.gov.nist.javax.sip.stack.timers.DefaultSipTimer;
import android.gov.nist.javax.sip.stack.timers.SipTimer;
import android.javax.sip.InvalidArgumentException;
import android.javax.sip.ListeningPoint;
import android.javax.sip.ObjectInUseException;
import android.javax.sip.PeerUnavailableException;
import android.javax.sip.ProviderDoesNotExistException;
import android.javax.sip.SipException;
import android.javax.sip.SipListener;
import android.javax.sip.SipProvider;
import android.javax.sip.SipStack;
import android.javax.sip.TransportNotSupportedException;
import android.javax.sip.address.Router;
import android.javax.sip.header.HeaderFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.GeneralSecurityException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class SipStackImpl
extends SIPTransactionStack
implements SipStack,
SipStackExt {
    private static StackLogger logger = CommonLogger.getLogger(SipStackImpl.class);
    private EventScanner eventScanner;
    protected Hashtable<String, ListeningPointImpl> listeningPoints;
    protected List<SipProviderImpl> sipProviders;
    public static final Integer MAX_DATAGRAM_SIZE = 65536;
    private boolean reEntrantListener;
    SipListener sipListener;
    TlsSecurityPolicy tlsSecurityPolicy;
    private Semaphore stackSemaphore;
    public static final String[] DEFAULT_CIPHERS = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
    private String[] cipherSuites;
    private String[] enabledProtocols;
    private Properties configurationProperties;

    protected SipStackImpl() {
        this.stackSemaphore = new Semaphore(1);
        this.cipherSuites = DEFAULT_CIPHERS;
        this.enabledProtocols = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
        NistSipMessageFactoryImpl msgFactory = new NistSipMessageFactoryImpl(this);
        super.setMessageFactory(msgFactory);
        this.eventScanner = new EventScanner(this);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new CopyOnWriteArrayList<SipProviderImpl>();
        try {
            Charset charset = Charset.forName("UTF-8");
            if (charset == null) {
                throw new UnsupportedCharsetException("Unsupported charset UTF-8");
            }
        }
        catch (Exception e) {
            logger.logWarning("UTF-8 charset cannot be used this system. This will lead to unpredictable behavior when parsing SIP messages: " + e.getMessage());
        }
    }

    private void reInitialize() {
        super.reInit();
        this.eventScanner = new EventScanner(this);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new CopyOnWriteArrayList<SipProviderImpl>();
        this.sipListener = null;
        if (!this.getTimer().isStarted()) {
            String defaultTimerName = this.configurationProperties.getProperty("android.gov.nist.javax.sip.TIMER_CLASS_NAME", DefaultSipTimer.class.getName());
            try {
                this.setTimer((SipTimer)Class.forName(defaultTimerName).newInstance());
                this.getTimer().start(this, this.configurationProperties);
                if (this.getThreadAuditor() != null && this.getThreadAuditor().isEnabled()) {
                    this.getTimer().schedule(new SIPTransactionStack.PingTimer(this, null), 0L);
                }
            }
            catch (Exception e) {
                logger.logError("Bad configuration value for android.gov.nist.javax.sip.TIMER_CLASS_NAME", e);
            }
        }
    }

    boolean isAutomaticDialogSupportEnabled() {
        return this.isAutomaticDialogSupportEnabled;
    }

    public SipStackImpl(Properties configurationProperties) throws PeerUnavailableException {
        String interceptorClassName;
        String valveClassName;
        String releaseReferencesStrategyString;
        InputStream in;
        String cipherSuitesStr;
        block142: {
            block141: {
                String stunAddr;
                block140: {
                    String connTimeout;
                    String readTimeout;
                    block139: {
                        String clientTransactionTableSize;
                        String serverTransactionTableSize;
                        block138: {
                            block137: {
                                String threadPoolSize;
                                block136: {
                                    String maxConnections;
                                    String tlsPolicyPath;
                                    String clientAuthType;
                                    String extensionMethods;
                                    this();
                                    this.configurationProperties = configurationProperties = new MergedSystemProperties(configurationProperties);
                                    String address = configurationProperties.getProperty("android.javax.sip.IP_ADDRESS");
                                    try {
                                        if (address != null) {
                                            super.setHostAddress(address);
                                        }
                                    }
                                    catch (UnknownHostException ex) {
                                        throw new PeerUnavailableException("bad address " + address);
                                    }
                                    String name = configurationProperties.getProperty("android.javax.sip.STACK_NAME");
                                    if (name == null) {
                                        throw new PeerUnavailableException("stack name is missing");
                                    }
                                    super.setStackName(name);
                                    String stackLoggerClassName = configurationProperties.getProperty("android.gov.nist.javax.sip.STACK_LOGGER");
                                    if (stackLoggerClassName == null) {
                                        stackLoggerClassName = "android.gov.nist.core.LogWriter";
                                    }
                                    try {
                                        StackLogger stackLogger;
                                        Class<?> stackLoggerClass = Class.forName(stackLoggerClassName);
                                        Class[] constructorArgs = new Class[]{};
                                        Constructor<?> cons = stackLoggerClass.getConstructor(constructorArgs);
                                        Object[] args = new Object[]{};
                                        CommonLogger.legacyLogger = stackLogger = (StackLogger)cons.newInstance(args);
                                        stackLogger.setStackProperties(configurationProperties);
                                    }
                                    catch (InvocationTargetException ex1) {
                                        throw new IllegalArgumentException("Cound not instantiate stack logger " + stackLoggerClassName + "- check that it is present on the classpath and that there is a no-args constructor defined", ex1);
                                    }
                                    catch (Exception ex) {
                                        throw new IllegalArgumentException("Cound not instantiate stack logger " + stackLoggerClassName + "- check that it is present on the classpath and that there is a no-args constructor defined", ex);
                                    }
                                    String serverLoggerClassName = configurationProperties.getProperty("android.gov.nist.javax.sip.SERVER_LOGGER");
                                    if (serverLoggerClassName == null) {
                                        serverLoggerClassName = "android.gov.nist.javax.sip.stack.ServerLog";
                                    }
                                    try {
                                        Class<?> serverLoggerClass = Class.forName(serverLoggerClassName);
                                        Class[] constructorArgs = new Class[]{};
                                        Constructor<?> cons = serverLoggerClass.getConstructor(constructorArgs);
                                        Object[] args = new Object[]{};
                                        this.serverLogger = (ServerLogger)cons.newInstance(args);
                                        this.serverLogger.setSipStack(this);
                                        this.serverLogger.setStackProperties(configurationProperties);
                                    }
                                    catch (InvocationTargetException ex1) {
                                        throw new IllegalArgumentException("Cound not instantiate server logger " + stackLoggerClassName + "- check that it is present on the classpath and that there is a no-args constructor defined", ex1);
                                    }
                                    catch (Exception ex) {
                                        throw new IllegalArgumentException("Cound not instantiate server logger " + stackLoggerClassName + "- check that it is present on the classpath and that there is a no-args constructor defined", ex);
                                    }
                                    super.setReliableConnectionKeepAliveTimeout(1000 * Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.RELIABLE_CONNECTION_KEEP_ALIVE_TIMEOUT", "-1")));
                                    super.setSslHandshakeTimeout(Long.parseLong(configurationProperties.getProperty("android.gov.nist.javax.sip.SSL_HANDSHAKE_TIMEOUT", "-1")));
                                    super.setThreadPriority(Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.THREAD_PRIORITY", "10")));
                                    this.outboundProxy = configurationProperties.getProperty("android.javax.sip.OUTBOUND_PROXY");
                                    ByteBufferFactory.getInstance().setUseDirect(Boolean.valueOf(configurationProperties.getProperty("android.gov.nist.javax.sip.stack.USE_DIRECT_BUFFERS", Boolean.TRUE.toString())));
                                    this.defaultRouter = new DefaultRouter(this, this.outboundProxy);
                                    String routerPath = configurationProperties.getProperty("android.javax.sip.ROUTER_PATH");
                                    if (routerPath == null) {
                                        routerPath = "android.gov.nist.javax.sip.stack.DefaultRouter";
                                    }
                                    try {
                                        Class<?> routerClass = Class.forName(routerPath);
                                        Class[] constructorArgs = new Class[]{SipStack.class, String.class};
                                        Constructor<?> cons = routerClass.getConstructor(constructorArgs);
                                        Object[] args = new Object[]{this, this.outboundProxy};
                                        Router router = (Router)cons.newInstance(args);
                                        super.setRouter(router);
                                    }
                                    catch (InvocationTargetException ex1) {
                                        logger.logError("could not instantiate router -- invocation target problem", (Exception)ex1.getCause());
                                        throw new PeerUnavailableException("Cound not instantiate router - check constructor", ex1);
                                    }
                                    catch (Exception ex) {
                                        logger.logError("could not instantiate router", (Exception)ex.getCause());
                                        throw new PeerUnavailableException("Could not instantiate router", ex);
                                    }
                                    String useRouterForAll = configurationProperties.getProperty("android.javax.sip.USE_ROUTER_FOR_ALL_URIS");
                                    this.useRouterForAll = true;
                                    if (useRouterForAll != null) {
                                        this.useRouterForAll = "true".equalsIgnoreCase(useRouterForAll);
                                    }
                                    if ((extensionMethods = configurationProperties.getProperty("android.javax.sip.EXTENSION_METHODS")) != null) {
                                        StringTokenizer st = new StringTokenizer(extensionMethods);
                                        while (st.hasMoreTokens()) {
                                            String em = st.nextToken(":");
                                            if (em.equalsIgnoreCase("BYE") || em.equalsIgnoreCase("INVITE") || em.equalsIgnoreCase("SUBSCRIBE") || em.equalsIgnoreCase("NOTIFY") || em.equalsIgnoreCase("ACK") || em.equalsIgnoreCase("OPTIONS")) {
                                                throw new PeerUnavailableException("Bad extension method " + em);
                                            }
                                            this.addExtensionMethod(em);
                                        }
                                    }
                                    if ((clientAuthType = configurationProperties.getProperty("android.gov.nist.javax.sip.TLS_CLIENT_AUTH_TYPE")) != null) {
                                        this.clientAuth = ClientAuthType.valueOf(clientAuthType);
                                        logger.logInfo("using " + clientAuthType + " tls auth policy");
                                    }
                                    String keyStoreFile = configurationProperties.getProperty("javax.net.ssl.keyStore");
                                    String trustStoreFile = configurationProperties.getProperty("javax.net.ssl.trustStore");
                                    if (keyStoreFile != null) {
                                        if (trustStoreFile == null) {
                                            trustStoreFile = keyStoreFile;
                                        }
                                        String keyStorePassword = configurationProperties.getProperty("javax.net.ssl.keyStorePassword");
                                        String trustStorePassword = configurationProperties.getProperty("javax.net.ssl.trustStorePassword", keyStorePassword);
                                        String keyStoreType = configurationProperties.getProperty("javax.net.ssl.keyStoreType");
                                        String trustStoreType = configurationProperties.getProperty("javax.net.ssl.trustStoreType");
                                        if (trustStoreType == null) {
                                            trustStoreType = keyStoreType;
                                        }
                                        try {
                                            this.networkLayer = new SslNetworkLayer(this, trustStoreFile, keyStoreFile, keyStorePassword != null ? keyStorePassword.toCharArray() : null, trustStorePassword != null ? trustStorePassword.toCharArray() : null, keyStoreType, trustStoreType);
                                        }
                                        catch (Exception e1) {
                                            logger.logError("could not instantiate SSL networking", e1);
                                        }
                                    }
                                    this.isAutomaticDialogSupportEnabled = configurationProperties.getProperty("android.javax.sip.AUTOMATIC_DIALOG_SUPPORT", "on").equalsIgnoreCase("on");
                                    this.isAutomaticDialogErrorHandlingEnabled = configurationProperties.getProperty("android.gov.nist.javax.sip.AUTOMATIC_DIALOG_ERROR_HANDLING", "true").equals(Boolean.TRUE.toString());
                                    if (this.isAutomaticDialogSupportEnabled) {
                                        this.isAutomaticDialogErrorHandlingEnabled = true;
                                    }
                                    if (configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME") != null) {
                                        this.maxListenerResponseTime = Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME"));
                                        if (this.maxListenerResponseTime <= 0) {
                                            throw new PeerUnavailableException("Bad configuration parameter android.gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME : should be positive");
                                        }
                                    } else {
                                        this.maxListenerResponseTime = -1;
                                    }
                                    if (configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_TX_LIFETIME_INVITE") != null) {
                                        this.maxTxLifetimeInvite = Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_TX_LIFETIME_INVITE"));
                                        if (super.getMaxTxLifetimeInvite() <= 0) {
                                            throw new PeerUnavailableException("Bad configuration parameter android.gov.nist.javax.sip.MAX_TX_LIFETIME_INVITE : should be positive");
                                        }
                                    } else {
                                        this.maxTxLifetimeInvite = -1;
                                    }
                                    if (configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_TX_LIFETIME_NON_INVITE") != null) {
                                        this.maxTxLifetimeNonInvite = Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_TX_LIFETIME_NON_INVITE"));
                                        if (super.getMaxTxLifetimeNonInvite() <= 0) {
                                            throw new PeerUnavailableException("Bad configuration parameter android.gov.nist.javax.sip.MAX_TX_LIFETIME_NON_INVITE : should be positive");
                                        }
                                    } else {
                                        this.maxTxLifetimeNonInvite = -1;
                                    }
                                    this.setDeliverTerminatedEventForAck(configurationProperties.getProperty("android.gov.nist.javax.sip.DELIVER_TERMINATED_EVENT_FOR_ACK", "false").equalsIgnoreCase("true"));
                                    super.setDeliverUnsolicitedNotify(Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.DELIVER_UNSOLICITED_NOTIFY", "false")));
                                    String forkedSubscriptions = configurationProperties.getProperty("android.javax.sip.FORKABLE_EVENTS");
                                    if (forkedSubscriptions != null) {
                                        StringTokenizer st = new StringTokenizer(forkedSubscriptions);
                                        while (st.hasMoreTokens()) {
                                            String nextEvent = st.nextToken();
                                            this.forkedEvents.add(nextEvent);
                                        }
                                    }
                                    if ((tlsPolicyPath = configurationProperties.getProperty("android.gov.nist.javax.sip.TLS_SECURITY_POLICY")) == null) {
                                        tlsPolicyPath = "android.gov.nist.javax.sip.stack.DefaultTlsSecurityPolicy";
                                        logger.logWarning("using default tls security policy");
                                    }
                                    try {
                                        Class<?> tlsPolicyClass = Class.forName(tlsPolicyPath);
                                        Class[] constructorArgs = new Class[]{};
                                        Constructor<?> cons = tlsPolicyClass.getConstructor(constructorArgs);
                                        Object[] args = new Object[]{};
                                        this.tlsSecurityPolicy = (TlsSecurityPolicy)cons.newInstance(args);
                                    }
                                    catch (InvocationTargetException ex1) {
                                        throw new IllegalArgumentException("Cound not instantiate TLS security policy " + tlsPolicyPath + "- check that it is present on the classpath and that there is a no-args constructor defined", ex1);
                                    }
                                    catch (Exception ex) {
                                        throw new IllegalArgumentException("Cound not instantiate TLS security policy " + tlsPolicyPath + "- check that it is present on the classpath and that there is a no-args constructor defined", ex);
                                    }
                                    String NETWORK_LAYER_KEY = "android.gov.nist.javax.sip.NETWORK_LAYER";
                                    if (configurationProperties.containsKey("android.gov.nist.javax.sip.NETWORK_LAYER")) {
                                        String path = configurationProperties.getProperty("android.gov.nist.javax.sip.NETWORK_LAYER");
                                        try {
                                            Class<?> clazz = Class.forName(path);
                                            Constructor<?> c = clazz.getConstructor(new Class[0]);
                                            this.networkLayer = (NetworkLayer)c.newInstance(new Object[0]);
                                            this.networkLayer.setSipStack(this);
                                        }
                                        catch (Exception e) {
                                            throw new PeerUnavailableException("can't find or instantiate NetworkLayer implementation: " + path, e);
                                        }
                                    }
                                    String ADDRESS_RESOLVER_KEY = "android.gov.nist.javax.sip.ADDRESS_RESOLVER";
                                    if (configurationProperties.containsKey("android.gov.nist.javax.sip.ADDRESS_RESOLVER")) {
                                        String path = configurationProperties.getProperty("android.gov.nist.javax.sip.ADDRESS_RESOLVER");
                                        try {
                                            Class<?> clazz = Class.forName(path);
                                            Constructor<?> c = clazz.getConstructor(new Class[0]);
                                            this.addressResolver = (AddressResolver)c.newInstance(new Object[0]);
                                        }
                                        catch (Exception e) {
                                            throw new PeerUnavailableException("can't find or instantiate AddressResolver implementation: " + path, e);
                                        }
                                    }
                                    if ((maxConnections = configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_CONNECTIONS")) != null) {
                                        try {
                                            this.maxConnections = new Integer(maxConnections);
                                        }
                                        catch (NumberFormatException ex) {
                                            if (!logger.isLoggingEnabled()) break block136;
                                            logger.logError("max connections - bad value " + ex.getMessage());
                                        }
                                    }
                                }
                                if ((threadPoolSize = configurationProperties.getProperty("android.gov.nist.javax.sip.THREAD_POOL_SIZE")) != null) {
                                    try {
                                        this.threadPoolSize = new Integer(threadPoolSize);
                                    }
                                    catch (NumberFormatException ex) {
                                        if (!logger.isLoggingEnabled()) break block137;
                                        logger.logError("thread pool size - bad value " + ex.getMessage());
                                    }
                                }
                            }
                            int congetstionControlTimeout = Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.CONGESTION_CONTROL_TIMEOUT", "8000"));
                            super.setStackCongestionControlTimeout(congetstionControlTimeout);
                            String tcpTreadPoolSize = configurationProperties.getProperty("android.gov.nist.javax.sip.TCP_POST_PARSING_THREAD_POOL_SIZE");
                            if (tcpTreadPoolSize != null) {
                                try {
                                    int threads = new Integer(tcpTreadPoolSize);
                                    super.setTcpPostParsingThreadPoolSize(threads);
                                    PostParseExecutorServices.setPostParseExcutorSize(this, threads, congetstionControlTimeout);
                                }
                                catch (NumberFormatException ex) {
                                    if (!logger.isLoggingEnabled()) break block138;
                                    logger.logError("TCP post-parse thread pool size - bad value " + tcpTreadPoolSize + " : " + ex.getMessage());
                                }
                            }
                        }
                        if ((serverTransactionTableSize = configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS")) != null) {
                            try {
                                this.serverTransactionTableHighwaterMark = new Integer(serverTransactionTableSize);
                                this.serverTransactionTableLowaterMark = this.serverTransactionTableHighwaterMark * 80 / 100;
                            }
                            catch (NumberFormatException ex) {
                                if (logger.isLoggingEnabled()) {
                                    logger.logError("transaction table size - bad value " + ex.getMessage());
                                }
                            }
                        } else {
                            this.unlimitedServerTransactionTableSize = true;
                        }
                        if ((clientTransactionTableSize = configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_CLIENT_TRANSACTIONS")) != null) {
                            try {
                                this.clientTransactionTableHiwaterMark = new Integer(clientTransactionTableSize);
                                this.clientTransactionTableLowaterMark = this.clientTransactionTableLowaterMark * 80 / 100;
                            }
                            catch (NumberFormatException ex) {
                                if (logger.isLoggingEnabled()) {
                                    logger.logError("transaction table size - bad value " + ex.getMessage());
                                }
                            }
                        } else {
                            this.unlimitedClientTransactionTableSize = true;
                        }
                        String SECURITY_MANAGER_PROVIDER_KEY = "android.gov.nist.javax.sip.SECURITY_MANAGER_PROVIDER";
                        if (configurationProperties.containsKey("android.gov.nist.javax.sip.SECURITY_MANAGER_PROVIDER")) {
                            String path = configurationProperties.getProperty("android.gov.nist.javax.sip.SECURITY_MANAGER_PROVIDER");
                            try {
                                Class<?> clazz = Class.forName(path);
                                Constructor<?> c = clazz.getConstructor(new Class[0]);
                                this.securityManagerProvider = (SecurityManagerProvider)c.newInstance(new Object[0]);
                            }
                            catch (Exception e) {
                                throw new PeerUnavailableException("can't find or instantiate SecurityManagerProvider implementation: " + path, e);
                            }
                        } else {
                            this.securityManagerProvider = new DefaultSecurityManagerProvider();
                        }
                        try {
                            this.securityManagerProvider.init(configurationProperties);
                        }
                        catch (GeneralSecurityException ex) {
                            throw new PeerUnavailableException("Cannot initialize security manager provider", ex);
                        }
                        catch (IOException ex) {
                            throw new PeerUnavailableException("Cannot initialize security manager provider", ex);
                        }
                        this.cacheServerConnections = true;
                        String flag = configurationProperties.getProperty("android.gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS");
                        if (flag != null && "false".equalsIgnoreCase(flag.trim())) {
                            this.cacheServerConnections = false;
                        }
                        this.cacheClientConnections = true;
                        String cacheflag = configurationProperties.getProperty("android.gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS");
                        if (cacheflag != null && "false".equalsIgnoreCase(cacheflag.trim())) {
                            this.cacheClientConnections = false;
                        }
                        if ((readTimeout = configurationProperties.getProperty("android.gov.nist.javax.sip.READ_TIMEOUT")) != null) {
                            try {
                                int rt = Integer.parseInt(readTimeout);
                                if (rt >= 100) {
                                    this.readTimeout = rt;
                                } else {
                                    System.err.println("Value too low " + readTimeout);
                                }
                            }
                            catch (NumberFormatException nfe) {
                                if (!logger.isLoggingEnabled()) break block139;
                                logger.logError("Bad read timeout " + readTimeout);
                            }
                        }
                    }
                    if ((connTimeout = configurationProperties.getProperty("android.gov.nist.javax.sip.CONNECTION_TIMEOUT")) != null) {
                        try {
                            int rt = Integer.parseInt(connTimeout);
                            if (rt >= 100) {
                                this.connTimeout = rt;
                            } else {
                                System.err.println("Value too low " + readTimeout);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (!logger.isLoggingEnabled()) break block140;
                            logger.logError("Bad conn timeout " + readTimeout);
                        }
                    }
                }
                if ((stunAddr = configurationProperties.getProperty("android.gov.nist.javax.sip.STUN_SERVER")) != null) {
                    logger.logWarning("Ignoring obsolete property android.gov.nist.javax.sip.STUN_SERVER");
                }
                String maxMsgSize = configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_MESSAGE_SIZE");
                try {
                    if (maxMsgSize != null) {
                        this.maxMessageSize = new Integer(maxMsgSize);
                        if (this.maxMessageSize < 4096) {
                            this.maxMessageSize = 4096;
                        }
                    } else {
                        this.maxMessageSize = 0;
                    }
                }
                catch (NumberFormatException ex) {
                    if (!logger.isLoggingEnabled()) break block141;
                    logger.logError("maxMessageSize - bad value " + ex.getMessage());
                }
            }
            String rel = configurationProperties.getProperty("android.gov.nist.javax.sip.REENTRANT_LISTENER");
            this.reEntrantListener = rel != null && "true".equalsIgnoreCase(rel);
            String interval = configurationProperties.getProperty("android.gov.nist.javax.sip.THREAD_AUDIT_INTERVAL_IN_MILLISECS");
            if (interval != null) {
                try {
                    this.threadAuditor = new ThreadAuditor();
                    this.getThreadAuditor().setPingIntervalInMillisecs(Long.valueOf(interval) / 2L);
                }
                catch (NumberFormatException ex) {
                    if (!logger.isLoggingEnabled()) break block142;
                    logger.logError("THREAD_AUDIT_INTERVAL_IN_MILLISECS - bad value [" + interval + "] " + ex.getMessage());
                }
            }
        }
        this.setNon2XXAckPassedToListener(Boolean.valueOf(configurationProperties.getProperty("android.gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER", "false")));
        this.generateTimeStampHeader = Boolean.valueOf(configurationProperties.getProperty("android.gov.nist.javax.sip.AUTO_GENERATE_TIMESTAMP", "false"));
        String messageLogFactoryClasspath = configurationProperties.getProperty("android.gov.nist.javax.sip.LOG_FACTORY");
        if (messageLogFactoryClasspath != null) {
            try {
                Class<?> clazz = Class.forName(messageLogFactoryClasspath);
                Constructor<?> c = clazz.getConstructor(new Class[0]);
                this.logRecordFactory = (LogRecordFactory)c.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("Bad configuration value for LOG_FACTORY -- using default logger");
                }
                this.logRecordFactory = new DefaultMessageLogFactory();
            }
        } else {
            this.logRecordFactory = new DefaultMessageLogFactory();
        }
        boolean computeContentLength = configurationProperties.getProperty("android.gov.nist.javax.sip.COMPUTE_CONTENT_LENGTH_FROM_MESSAGE_BODY", "false").equalsIgnoreCase("true");
        StringMsgParser.setComputeContentLengthFromMessage(computeContentLength);
        String tlsClientProtocols = configurationProperties.getProperty("android.gov.nist.javax.sip.TLS_CLIENT_PROTOCOLS");
        if (tlsClientProtocols != null) {
            StringTokenizer st = new StringTokenizer(tlsClientProtocols, "\" ,");
            String[] protocols = new String[st.countTokens()];
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("TLS Client Protocols = ");
            }
            int i = 0;
            while (st.hasMoreTokens()) {
                protocols[i] = st.nextToken();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("TLS Client Protocol = " + protocols[i]);
                }
                ++i;
            }
            this.enabledProtocols = protocols;
        }
        if ((cipherSuitesStr = configurationProperties.getProperty("android.gov.nist.javax.sip.ENABLED_CIPHER_SUITES")) != null) {
            StringTokenizer st = new StringTokenizer(cipherSuitesStr, "\" ,");
            String[] newCipherSuites = new String[st.countTokens()];
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Cipher Suites = ");
            }
            int i = 0;
            while (st.hasMoreTokens()) {
                newCipherSuites[i] = st.nextToken();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Cipher Suite = " + newCipherSuites[i]);
                }
                ++i;
            }
            this.cipherSuites = newCipherSuites;
        }
        this.rfc2543Supported = configurationProperties.getProperty("android.gov.nist.javax.sip.RFC_2543_SUPPORT_ENABLED", "true").equalsIgnoreCase("true");
        super.setPatchWebSocketHeaders(Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.PATCH_SIP_WEBSOCKETS_HEADERS", "true")));
        super.setPatchRport(Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.ALWAYS_ADD_RPORT", "false")));
        super.setPatchReceivedRport(Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.NEVER_ADD_RECEIVED_RPORT", "false")));
        this.cancelClientTransactionChecked = configurationProperties.getProperty("android.gov.nist.javax.sip.CANCEL_CLIENT_TRANSACTION_CHECKED", "true").equalsIgnoreCase("true");
        this.logStackTraceOnMessageSend = configurationProperties.getProperty("android.gov.nist.javax.sip.LOG_STACK_TRACE_ON_MESSAGE_SEND", "false").equalsIgnoreCase("true");
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("created Sip stack. Properties = " + configurationProperties);
        }
        if ((in = this.getClass().getResourceAsStream("/TIMESTAMP")) != null) {
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(in));
            try {
                String buildTimeStamp = streamReader.readLine();
                if (in != null) {
                    in.close();
                }
                logger.setBuildTimeStamp(buildTimeStamp);
            }
            catch (IOException ex) {
                logger.logError("Could not open build timestamp.");
            }
        }
        String bufferSize = configurationProperties.getProperty("android.gov.nist.javax.sip.RECEIVE_UDP_BUFFER_SIZE", MAX_DATAGRAM_SIZE.toString());
        int bufferSizeInteger = new Integer(bufferSize);
        super.setReceiveUdpBufferSize(bufferSizeInteger);
        bufferSize = configurationProperties.getProperty("android.gov.nist.javax.sip.SEND_UDP_BUFFER_SIZE", MAX_DATAGRAM_SIZE.toString());
        bufferSizeInteger = new Integer(bufferSize);
        super.setSendUdpBufferSize(bufferSizeInteger);
        super.setConnectionLingerTimer(Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.LINGER_TIMER", "8")));
        this.isBackToBackUserAgent = Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.IS_BACK_TO_BACK_USER_AGENT", Boolean.FALSE.toString()));
        this.checkBranchId = Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.REJECT_STRAY_RESPONSES", Boolean.FALSE.toString()));
        this.isDialogTerminatedEventDeliveredForNullDialog = Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.DELIVER_TERMINATED_EVENT_FOR_NULL_DIALOG", Boolean.FALSE.toString()));
        this.maxForkTime = Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.MAX_FORK_TIME_SECONDS", "0"));
        this.earlyDialogTimeout = Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.EARLY_DIALOG_TIMEOUT_SECONDS", "180"));
        this.minKeepAliveInterval = Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.MIN_KEEPALIVE_TIME_SECONDS", "-1"));
        this.deliverRetransmittedAckToListener = Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.DELIVER_RETRANSMITTED_ACK_TO_LISTENER", "false"));
        this.dialogTimeoutFactor = Integer.parseInt(configurationProperties.getProperty("android.gov.nist.javax.sip.DIALOG_TIMEOUT_FACTOR", "64"));
        String messageParserFactoryName = configurationProperties.getProperty("android.gov.nist.javax.sip.MESSAGE_PARSER_FACTORY", StringMsgParserFactory.class.getName());
        try {
            this.messageParserFactory = (MessageParserFactory)Class.forName(messageParserFactoryName).newInstance();
        }
        catch (Exception e) {
            logger.logError("Bad configuration value for android.gov.nist.javax.sip.MESSAGE_PARSER_FACTORY", e);
        }
        String messageProcessorFactoryName = configurationProperties.getProperty("android.gov.nist.javax.sip.MESSAGE_PROCESSOR_FACTORY", OIOMessageProcessorFactory.class.getName());
        try {
            this.messageProcessorFactory = (MessageProcessorFactory)Class.forName(messageProcessorFactoryName).newInstance();
        }
        catch (Exception e) {
            logger.logError("Bad configuration value for android.gov.nist.javax.sip.MESSAGE_PROCESSOR_FACTORY", e);
        }
        String maxIdleTimeString = configurationProperties.getProperty("android.gov.nist.javax.sip.NIO_MAX_SOCKET_IDLE_TIME", "7200000");
        try {
            this.nioSocketMaxIdleTime = Long.parseLong(maxIdleTimeString);
        }
        catch (Exception e) {
            logger.logError("Bad configuration value for android.gov.nist.javax.sip.NIO_MAX_SOCKET_IDLE_TIME=" + maxIdleTimeString, e);
        }
        String nioMode = configurationProperties.getProperty("android.gov.nist.javax.sip.NIO_BLOCKING_MODE", "BLOCKING");
        try {
            this.nioMode = NIOMode.valueOf(nioMode);
        }
        catch (Exception e) {
            logger.logError("Bad configuration value for android.gov.nist.javax.sip.NIO_BLOCKING_MODE=" + nioMode, e);
        }
        String defaultTimerName = configurationProperties.getProperty("android.gov.nist.javax.sip.TIMER_CLASS_NAME", DefaultSipTimer.class.getName());
        try {
            this.setTimer((SipTimer)Class.forName(defaultTimerName).newInstance());
            this.getTimer().start(this, configurationProperties);
            if (this.getThreadAuditor() != null && this.getThreadAuditor().isEnabled()) {
                this.getTimer().schedule(new SIPTransactionStack.PingTimer(this, null), 0L);
            }
        }
        catch (Exception e) {
            logger.logError("Bad configuration value for android.gov.nist.javax.sip.TIMER_CLASS_NAME", e);
        }
        boolean aggressiveCleanup = Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.AGGRESSIVE_CLEANUP", Boolean.FALSE.toString()));
        if (aggressiveCleanup) {
            this.setReleaseReferencesStrategy(ReleaseReferencesStrategy.Normal);
        }
        if ((releaseReferencesStrategyString = configurationProperties.getProperty("android.gov.nist.javax.sip.RELEASE_REFERENCES_STRATEGY")) != null) {
            this.setReleaseReferencesStrategy(ReleaseReferencesStrategy.valueOf(releaseReferencesStrategyString));
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Using following release references strategy " + (Object)((Object)this.getReleaseReferencesStrategy()));
            }
        }
        if ((valveClassName = configurationProperties.getProperty("android.gov.nist.javax.sip.SIP_MESSAGE_VALVE", null)) != null && !valveClassName.equals("")) {
            String[] valves;
            for (String valve : valves = valveClassName.split(",")) {
                try {
                    SIPMessageValve sipMessageValve = (SIPMessageValve)Class.forName(valve).newInstance();
                    SipStackImpl thisStack = this;
                    try {
                        Thread.sleep(100L);
                        sipMessageValve.init(thisStack);
                    }
                    catch (Exception e) {
                        logger.logError("Error intializing SIPMessageValve", e);
                    }
                    this.sipMessageValves.add(sipMessageValve);
                }
                catch (Exception e) {
                    logger.logError("Bad configuration value for android.gov.nist.javax.sip.SIP_MESSAGE_VALVE", e);
                }
            }
        }
        if ((interceptorClassName = configurationProperties.getProperty("android.gov.nist.javax.sip.SIP_EVENT_INTERCEPTOR", null)) != null && !interceptorClassName.equals("")) {
            try {
                this.sipEventInterceptor = (SIPEventInterceptor)Class.forName(interceptorClassName).newInstance();
                final SipStackImpl thisStack = this;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                            SipStackImpl.this.sipEventInterceptor.init(thisStack);
                        }
                        catch (Exception e) {
                            logger.logError("Error intializing SIPEventInterceptor", e);
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                logger.logError("Bad configuration value for android.gov.nist.javax.sip.SIP_EVENT_INTERCEPTOR", e);
            }
        }
        boolean sslRenegotiationEnabled = Boolean.parseBoolean(configurationProperties.getProperty("android.gov.nist.javax.sip.SSL_RENEGOTIATION_ENABLED", "true"));
        this.setSslRenegotiationEnabled(sslRenegotiationEnabled);
    }

    @Override
    public synchronized ListeningPoint createListeningPoint(String address, int port, String transport) throws TransportNotSupportedException, InvalidArgumentException {
        String key;
        ListeningPointImpl lip;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("createListeningPoint : address = " + address + " port = " + port + " transport = " + transport);
        }
        if (address == null) {
            throw new NullPointerException("Address for listening point is null!");
        }
        if (transport == null) {
            throw new NullPointerException("null transport");
        }
        if (port <= 0) {
            throw new InvalidArgumentException("bad port");
        }
        if (!(transport.equalsIgnoreCase("UDP") || transport.equalsIgnoreCase("TLS") || transport.equalsIgnoreCase("TCP") || transport.equalsIgnoreCase("SCTP") || transport.equalsIgnoreCase("WS") || transport.equalsIgnoreCase("WSS"))) {
            throw new TransportNotSupportedException("bad transport " + transport);
        }
        if (!this.isAlive()) {
            this.toExit = false;
            this.reInitialize();
        }
        if ((lip = this.listeningPoints.get(key = ListeningPointImpl.makeKey(address, port, transport))) != null) {
            return lip;
        }
        try {
            InetAddress inetAddr = InetAddress.getByName(address);
            MessageProcessor messageProcessor = this.createMessageProcessor(inetAddr, port, transport);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Created Message Processor: " + address + " port = " + port + " transport = " + transport);
            }
            lip = new ListeningPointImpl(this, port, transport);
            lip.messageProcessor = messageProcessor;
            messageProcessor.setListeningPoint(lip);
            this.listeningPoints.put(key, lip);
            messageProcessor.start();
            return lip;
        }
        catch (IOException ex) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Invalid argument address = " + address + " port = " + port + " transport = " + transport);
            }
            throw new InvalidArgumentException(ex.getMessage(), ex);
        }
    }

    @Override
    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("createSipProvider: " + listeningPoint);
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        if (listeningPointImpl.sipProvider != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        SipProviderImpl provider = new SipProviderImpl(this);
        provider.setListeningPoint(listeningPointImpl);
        listeningPointImpl.sipProvider = provider;
        this.sipProviders.add(provider);
        return provider;
    }

    @Override
    public void deleteListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint arg");
        }
        ListeningPointImpl lip = (ListeningPointImpl)listeningPoint;
        super.removeMessageProcessor(lip.messageProcessor);
        String key = lip.getKey();
        this.listeningPoints.remove(key);
    }

    @Override
    public void deleteSipProvider(SipProvider sipProvider) throws ObjectInUseException {
        if (sipProvider == null) {
            throw new NullPointerException("null provider arg");
        }
        SipProviderImpl sipProviderImpl = (SipProviderImpl)sipProvider;
        if (sipProviderImpl.getSipListener() != null) {
            throw new ObjectInUseException("SipProvider still has an associated SipListener!");
        }
        sipProviderImpl.removeListeningPoints();
        sipProviderImpl.stop();
        this.sipProviders.remove(sipProvider);
        if (this.sipProviders.isEmpty()) {
            this.stopStack();
        }
    }

    @Override
    public String getIPAddress() {
        return super.getHostAddress();
    }

    @Override
    public Iterator getListeningPoints() {
        return this.listeningPoints.values().iterator();
    }

    @Override
    public boolean isRetransmissionFilterActive() {
        return true;
    }

    @Override
    public Iterator<SipProviderImpl> getSipProviders() {
        return this.sipProviders.iterator();
    }

    @Override
    public String getStackName() {
        return this.stackName;
    }

    protected void finalize() {
        this.stopStack();
    }

    @Override
    public ListeningPoint createListeningPoint(int port, String transport) throws TransportNotSupportedException, InvalidArgumentException {
        if (this.stackAddress == null) {
            throw new NullPointerException("Stack does not have a default IP Address!");
        }
        return this.createListeningPoint(this.stackAddress, port, transport);
    }

    @Override
    public void stop() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("stopStack -- stoppping the stack");
            logger.logStackTrace();
        }
        this.stopStack();
        if (this.sipMessageValves.size() != 0) {
            for (SIPMessageValve sipMessageValve : this.sipMessageValves) {
                sipMessageValve.destroy();
            }
        }
        if (this.sipEventInterceptor != null) {
            this.sipEventInterceptor.destroy();
        }
        this.sipProviders = new CopyOnWriteArrayList<SipProviderImpl>();
        this.listeningPoints = new Hashtable();
        if (this.eventScanner != null) {
            this.eventScanner.forceStop();
        }
        this.eventScanner = null;
        PostParseExecutorServices.shutdownThreadpool();
    }

    @Override
    public void start() throws ProviderDoesNotExistException, SipException {
        if (this.eventScanner == null) {
            this.eventScanner = new EventScanner(this);
        }
    }

    @Override
    public SipListener getSipListener() {
        return this.sipListener;
    }

    public TlsSecurityPolicy getTlsSecurityPolicy() {
        return this.tlsSecurityPolicy;
    }

    public LogRecordFactory getLogRecordFactory() {
        return this.logRecordFactory;
    }

    @Deprecated
    public void addLogAppender(Appender appender) {
        if (logger instanceof LogWriter) {
            ((LogWriter)logger).addAppender(appender);
        }
    }

    @Deprecated
    public Logger getLogger() {
        if (logger instanceof LogWriter) {
            return ((LogWriter)logger).getLogger();
        }
        return null;
    }

    public EventScanner getEventScanner() {
        return this.eventScanner;
    }

    @Override
    public AuthenticationHelper getAuthenticationHelper(AccountManager accountManager, HeaderFactory headerFactory) {
        return new AuthenticationHelperImpl((SIPTransactionStack)this, accountManager, headerFactory);
    }

    @Override
    public AuthenticationHelper getSecureAuthenticationHelper(SecureAccountManager accountManager, HeaderFactory headerFactory) {
        return new AuthenticationHelperImpl((SIPTransactionStack)this, accountManager, headerFactory);
    }

    @Override
    public void setEnabledCipherSuites(String[] newCipherSuites) {
        this.cipherSuites = newCipherSuites;
    }

    public String[] getEnabledCipherSuites() {
        return this.cipherSuites;
    }

    public void setEnabledProtocols(String[] newProtocols) {
        this.enabledProtocols = newProtocols;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setIsBackToBackUserAgent(boolean flag) {
        this.isBackToBackUserAgent = flag;
    }

    public boolean isBackToBackUserAgent() {
        return this.isBackToBackUserAgent;
    }

    public boolean isAutomaticDialogErrorHandlingEnabled() {
        return this.isAutomaticDialogErrorHandlingEnabled;
    }

    public void setTlsSecurityPolicy(TlsSecurityPolicy tlsSecurityPolicy) {
        this.tlsSecurityPolicy = tlsSecurityPolicy;
    }

    public boolean acquireSem() {
        try {
            return this.stackSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public void releaseSem() {
        this.stackSemaphore.release();
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public boolean isReEntrantListener() {
        return this.reEntrantListener;
    }
}

