/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.NamingThreadFactory;
import android.gov.nist.core.StackLogger;
import android.gov.nist.javax.sip.MDCScheduledTHExecutor;
import android.gov.nist.javax.sip.ThreadAffinityIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadAffinityExecutor
implements ScheduledExecutorService {
    private static StackLogger logger = CommonLogger.getLogger(ThreadAffinityExecutor.class);
    private final List<MDCScheduledTHExecutor> executors;
    private final AtomicInteger nextThread = new AtomicInteger(0);

    public ThreadAffinityExecutor(int corePoolSize) {
        this.executors = new ArrayList<MDCScheduledTHExecutor>();
        NamingThreadFactory namingThreadFactory = new NamingThreadFactory("AffinityJAIN");
        for (int i = 0; i < corePoolSize; ++i) {
            this.executors.add(new MDCScheduledTHExecutor(1, namingThreadFactory));
        }
        this.schedulePurgeTaskIfNeeded();
    }

    private synchronized int retrieveNextThread() {
        int nThread = this.nextThread.incrementAndGet();
        if (nThread >= this.executors.size()) {
            nThread = 0;
            this.nextThread.set(0);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Next thread id=" + nThread);
        }
        return nThread;
    }

    private int calculateAffinityThread(Runnable runnable) {
        int affThreadIndex = 0;
        if (runnable instanceof ThreadAffinityIdentifier) {
            ThreadAffinityIdentifier tTask = (ThreadAffinityIdentifier)((Object)runnable);
            Object tHash = tTask.getThreadHash();
            if (tHash != null) {
                affThreadIndex = Math.abs(tHash.hashCode() % this.executors.size());
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Runnable assigned to thread (" + tHash + "," + affThreadIndex + ")");
                }
            } else {
                affThreadIndex = this.retrieveNextThread();
            }
        } else {
            affThreadIndex = this.retrieveNextThread();
        }
        return affThreadIndex;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        int affThread = this.calculateAffinityThread(command);
        return this.executors.get(affThread).schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        int affThread = this.calculateAffinityThread(command);
        return this.executors.get(affThread).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        int affThread = this.calculateAffinityThread(command);
        return this.executors.get(affThread).scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        for (ScheduledExecutorService scheduledExecutorService : this.executors) {
            scheduledExecutorService.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isShutdown() {
        return this.executors.get(0).isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executors.get(0).isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executors.get(0).awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        int affThread = this.calculateAffinityThread(task);
        return this.executors.get(affThread).submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        int affThread = this.calculateAffinityThread(task);
        return this.executors.get(affThread).submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void execute(Runnable command) {
        int affThread = this.calculateAffinityThread(command);
        this.executors.get(affThread).execute(command);
    }

    private void schedulePurgeTaskIfNeeded() {
    }
}

