/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header;

import android.gov.nist.javax.sip.header.CallIdentifier;
import android.gov.nist.javax.sip.header.SIPHeader;
import android.javax.sip.header.CallIdHeader;
import java.text.ParseException;

public class CallID
extends SIPHeader
implements CallIdHeader {
    private static final long serialVersionUID = -6463630258703731156L;
    public static final String NAME_LOWER = "Call-ID".toLowerCase();
    protected CallIdentifier callIdentifier;

    public CallID() {
        super("Call-ID");
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CallIdHeader) {
            CallIdHeader o = (CallIdHeader)other;
            return this.getCallId().equalsIgnoreCase(o.getCallId());
        }
        return false;
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.callIdentifier != null) {
            this.callIdentifier.encode(buffer);
        }
        return buffer;
    }

    @Override
    public String getCallId() {
        return this.encodeBody();
    }

    public CallIdentifier getCallIdentifer() {
        return this.callIdentifier;
    }

    @Override
    public void setCallId(String cid) throws ParseException {
        try {
            this.callIdentifier = new CallIdentifier(cid);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException(cid, 0);
        }
    }

    public void setCallIdentifier(CallIdentifier cid) {
        this.callIdentifier = cid;
    }

    public CallID(String callId) throws IllegalArgumentException {
        super("Call-ID");
        this.callIdentifier = new CallIdentifier(callId);
    }

    @Override
    public Object clone() {
        CallID retval = (CallID)super.clone();
        if (this.callIdentifier != null) {
            retval.callIdentifier = (CallIdentifier)this.callIdentifier.clone();
        }
        return retval;
    }
}

