/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header;

import android.gov.nist.javax.sip.header.SIPHeader;
import android.javax.sip.header.ContentLanguageHeader;
import java.util.Locale;

public class ContentLanguage
extends SIPHeader
implements ContentLanguageHeader {
    private static final long serialVersionUID = -5195728427134181070L;
    protected Locale locale;

    public ContentLanguage() {
        super("Content-Language");
    }

    public ContentLanguage(String languageTag) {
        super("Content-Language");
        this.setLanguageTag(languageTag);
    }

    @Override
    public StringBuilder encodeBody(StringBuilder buffer) {
        return buffer.append(this.getLanguageTag());
    }

    public String getLanguageTag() {
        if ("".equals(this.locale.getCountry())) {
            return this.locale.getLanguage();
        }
        return this.locale.getLanguage() + '-' + this.locale.getCountry();
    }

    public void setLanguageTag(String languageTag) {
        int slash = languageTag.indexOf(45);
        this.locale = slash >= 0 ? new Locale(languageTag.substring(0, slash), languageTag.substring(slash + 1)) : new Locale(languageTag);
    }

    @Override
    public Locale getContentLanguage() {
        return this.locale;
    }

    @Override
    public void setContentLanguage(Locale language) {
        this.locale = language;
    }

    @Override
    public Object clone() {
        ContentLanguage retval = (ContentLanguage)super.clone();
        if (this.locale != null) {
            retval.locale = (Locale)this.locale.clone();
        }
        return retval;
    }
}

