/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header;

import android.gov.nist.javax.sip.address.GenericURI;
import android.gov.nist.javax.sip.header.Accept;
import android.gov.nist.javax.sip.header.AcceptEncoding;
import android.gov.nist.javax.sip.header.AcceptLanguage;
import android.gov.nist.javax.sip.header.AlertInfo;
import android.gov.nist.javax.sip.header.Allow;
import android.gov.nist.javax.sip.header.AllowEvents;
import android.gov.nist.javax.sip.header.AuthenticationInfo;
import android.gov.nist.javax.sip.header.Authorization;
import android.gov.nist.javax.sip.header.CSeq;
import android.gov.nist.javax.sip.header.CallID;
import android.gov.nist.javax.sip.header.CallInfo;
import android.gov.nist.javax.sip.header.Contact;
import android.gov.nist.javax.sip.header.ContentDisposition;
import android.gov.nist.javax.sip.header.ContentEncoding;
import android.gov.nist.javax.sip.header.ContentLanguage;
import android.gov.nist.javax.sip.header.ContentLength;
import android.gov.nist.javax.sip.header.ContentType;
import android.gov.nist.javax.sip.header.ErrorInfo;
import android.gov.nist.javax.sip.header.Event;
import android.gov.nist.javax.sip.header.Expires;
import android.gov.nist.javax.sip.header.ExtensionHeaderImpl;
import android.gov.nist.javax.sip.header.From;
import android.gov.nist.javax.sip.header.HeaderFactoryExt;
import android.gov.nist.javax.sip.header.InReplyTo;
import android.gov.nist.javax.sip.header.MaxForwards;
import android.gov.nist.javax.sip.header.MimeVersion;
import android.gov.nist.javax.sip.header.MinExpires;
import android.gov.nist.javax.sip.header.Organization;
import android.gov.nist.javax.sip.header.Priority;
import android.gov.nist.javax.sip.header.ProxyAuthenticate;
import android.gov.nist.javax.sip.header.ProxyAuthorization;
import android.gov.nist.javax.sip.header.ProxyRequire;
import android.gov.nist.javax.sip.header.RAck;
import android.gov.nist.javax.sip.header.RSeq;
import android.gov.nist.javax.sip.header.Reason;
import android.gov.nist.javax.sip.header.RecordRoute;
import android.gov.nist.javax.sip.header.ReferTo;
import android.gov.nist.javax.sip.header.ReplyTo;
import android.gov.nist.javax.sip.header.Require;
import android.gov.nist.javax.sip.header.RetryAfter;
import android.gov.nist.javax.sip.header.Route;
import android.gov.nist.javax.sip.header.SIPDateHeader;
import android.gov.nist.javax.sip.header.SIPETag;
import android.gov.nist.javax.sip.header.SIPHeader;
import android.gov.nist.javax.sip.header.SIPHeaderList;
import android.gov.nist.javax.sip.header.SIPIfMatch;
import android.gov.nist.javax.sip.header.Server;
import android.gov.nist.javax.sip.header.SipRequestLine;
import android.gov.nist.javax.sip.header.SipStatusLine;
import android.gov.nist.javax.sip.header.Subject;
import android.gov.nist.javax.sip.header.SubscriptionState;
import android.gov.nist.javax.sip.header.Supported;
import android.gov.nist.javax.sip.header.TimeStamp;
import android.gov.nist.javax.sip.header.To;
import android.gov.nist.javax.sip.header.Unsupported;
import android.gov.nist.javax.sip.header.UserAgent;
import android.gov.nist.javax.sip.header.Via;
import android.gov.nist.javax.sip.header.WWWAuthenticate;
import android.gov.nist.javax.sip.header.Warning;
import android.gov.nist.javax.sip.header.extensions.Join;
import android.gov.nist.javax.sip.header.extensions.JoinHeader;
import android.gov.nist.javax.sip.header.extensions.MinSE;
import android.gov.nist.javax.sip.header.extensions.References;
import android.gov.nist.javax.sip.header.extensions.ReferencesHeader;
import android.gov.nist.javax.sip.header.extensions.ReferredBy;
import android.gov.nist.javax.sip.header.extensions.ReferredByHeader;
import android.gov.nist.javax.sip.header.extensions.Replaces;
import android.gov.nist.javax.sip.header.extensions.ReplacesHeader;
import android.gov.nist.javax.sip.header.extensions.SessionExpires;
import android.gov.nist.javax.sip.header.extensions.SessionExpiresHeader;
import android.gov.nist.javax.sip.header.ims.PAccessNetworkInfo;
import android.gov.nist.javax.sip.header.ims.PAccessNetworkInfoHeader;
import android.gov.nist.javax.sip.header.ims.PAssertedIdentity;
import android.gov.nist.javax.sip.header.ims.PAssertedIdentityHeader;
import android.gov.nist.javax.sip.header.ims.PAssertedService;
import android.gov.nist.javax.sip.header.ims.PAssertedServiceHeader;
import android.gov.nist.javax.sip.header.ims.PAssociatedURI;
import android.gov.nist.javax.sip.header.ims.PAssociatedURIHeader;
import android.gov.nist.javax.sip.header.ims.PCalledPartyID;
import android.gov.nist.javax.sip.header.ims.PCalledPartyIDHeader;
import android.gov.nist.javax.sip.header.ims.PChargingFunctionAddresses;
import android.gov.nist.javax.sip.header.ims.PChargingFunctionAddressesHeader;
import android.gov.nist.javax.sip.header.ims.PChargingVector;
import android.gov.nist.javax.sip.header.ims.PChargingVectorHeader;
import android.gov.nist.javax.sip.header.ims.PMediaAuthorization;
import android.gov.nist.javax.sip.header.ims.PMediaAuthorizationHeader;
import android.gov.nist.javax.sip.header.ims.PPreferredIdentity;
import android.gov.nist.javax.sip.header.ims.PPreferredIdentityHeader;
import android.gov.nist.javax.sip.header.ims.PPreferredService;
import android.gov.nist.javax.sip.header.ims.PPreferredServiceHeader;
import android.gov.nist.javax.sip.header.ims.PProfileKey;
import android.gov.nist.javax.sip.header.ims.PProfileKeyHeader;
import android.gov.nist.javax.sip.header.ims.PServedUser;
import android.gov.nist.javax.sip.header.ims.PServedUserHeader;
import android.gov.nist.javax.sip.header.ims.PUserDatabase;
import android.gov.nist.javax.sip.header.ims.PUserDatabaseHeader;
import android.gov.nist.javax.sip.header.ims.PVisitedNetworkID;
import android.gov.nist.javax.sip.header.ims.PVisitedNetworkIDHeader;
import android.gov.nist.javax.sip.header.ims.Path;
import android.gov.nist.javax.sip.header.ims.PathHeader;
import android.gov.nist.javax.sip.header.ims.Privacy;
import android.gov.nist.javax.sip.header.ims.PrivacyHeader;
import android.gov.nist.javax.sip.header.ims.SecurityClient;
import android.gov.nist.javax.sip.header.ims.SecurityClientHeader;
import android.gov.nist.javax.sip.header.ims.SecurityServer;
import android.gov.nist.javax.sip.header.ims.SecurityServerHeader;
import android.gov.nist.javax.sip.header.ims.SecurityVerify;
import android.gov.nist.javax.sip.header.ims.SecurityVerifyHeader;
import android.gov.nist.javax.sip.header.ims.ServiceRoute;
import android.gov.nist.javax.sip.header.ims.ServiceRouteHeader;
import android.gov.nist.javax.sip.parser.RequestLineParser;
import android.gov.nist.javax.sip.parser.StatusLineParser;
import android.gov.nist.javax.sip.parser.StringMsgParser;
import android.javax.sip.InvalidArgumentException;
import android.javax.sip.address.Address;
import android.javax.sip.address.URI;
import android.javax.sip.header.AcceptEncodingHeader;
import android.javax.sip.header.AcceptHeader;
import android.javax.sip.header.AcceptLanguageHeader;
import android.javax.sip.header.AlertInfoHeader;
import android.javax.sip.header.AllowEventsHeader;
import android.javax.sip.header.AllowHeader;
import android.javax.sip.header.AuthenticationInfoHeader;
import android.javax.sip.header.AuthorizationHeader;
import android.javax.sip.header.CSeqHeader;
import android.javax.sip.header.CallIdHeader;
import android.javax.sip.header.CallInfoHeader;
import android.javax.sip.header.ContactHeader;
import android.javax.sip.header.ContentDispositionHeader;
import android.javax.sip.header.ContentEncodingHeader;
import android.javax.sip.header.ContentLanguageHeader;
import android.javax.sip.header.ContentLengthHeader;
import android.javax.sip.header.ContentTypeHeader;
import android.javax.sip.header.DateHeader;
import android.javax.sip.header.ErrorInfoHeader;
import android.javax.sip.header.EventHeader;
import android.javax.sip.header.ExpiresHeader;
import android.javax.sip.header.ExtensionHeader;
import android.javax.sip.header.FromHeader;
import android.javax.sip.header.Header;
import android.javax.sip.header.HeaderFactory;
import android.javax.sip.header.InReplyToHeader;
import android.javax.sip.header.MaxForwardsHeader;
import android.javax.sip.header.MimeVersionHeader;
import android.javax.sip.header.MinExpiresHeader;
import android.javax.sip.header.OrganizationHeader;
import android.javax.sip.header.PriorityHeader;
import android.javax.sip.header.ProxyAuthenticateHeader;
import android.javax.sip.header.ProxyAuthorizationHeader;
import android.javax.sip.header.ProxyRequireHeader;
import android.javax.sip.header.RAckHeader;
import android.javax.sip.header.RSeqHeader;
import android.javax.sip.header.ReasonHeader;
import android.javax.sip.header.RecordRouteHeader;
import android.javax.sip.header.ReferToHeader;
import android.javax.sip.header.ReplyToHeader;
import android.javax.sip.header.RequireHeader;
import android.javax.sip.header.RetryAfterHeader;
import android.javax.sip.header.RouteHeader;
import android.javax.sip.header.SIPETagHeader;
import android.javax.sip.header.SIPIfMatchHeader;
import android.javax.sip.header.ServerHeader;
import android.javax.sip.header.SubjectHeader;
import android.javax.sip.header.SubscriptionStateHeader;
import android.javax.sip.header.SupportedHeader;
import android.javax.sip.header.TimeStampHeader;
import android.javax.sip.header.ToHeader;
import android.javax.sip.header.UnsupportedHeader;
import android.javax.sip.header.UserAgentHeader;
import android.javax.sip.header.ViaHeader;
import android.javax.sip.header.WWWAuthenticateHeader;
import android.javax.sip.header.WarningHeader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class HeaderFactoryImpl
implements HeaderFactory,
HeaderFactoryExt {
    private boolean stripAddressScopeZones = Boolean.getBoolean("android.gov.nist.core.STRIP_ADDR_SCOPES");

    public void setPrettyEncoding(boolean flag) {
        SIPHeaderList.setPrettyEncode(flag);
    }

    @Override
    public AcceptEncodingHeader createAcceptEncodingHeader(String encoding) throws ParseException {
        if (encoding == null) {
            throw new NullPointerException("the encoding parameter is null");
        }
        AcceptEncoding acceptEncoding = new AcceptEncoding();
        acceptEncoding.setEncoding(encoding);
        return acceptEncoding;
    }

    @Override
    public AcceptHeader createAcceptHeader(String contentType, String contentSubType) throws ParseException {
        if (contentType == null || contentSubType == null) {
            throw new NullPointerException("contentType or subtype is null ");
        }
        Accept accept = new Accept();
        accept.setContentType(contentType);
        accept.setContentSubType(contentSubType);
        return accept;
    }

    @Override
    public AcceptLanguageHeader createAcceptLanguageHeader(Locale language) {
        if (language == null) {
            throw new NullPointerException("null arg");
        }
        AcceptLanguage acceptLanguage = new AcceptLanguage();
        acceptLanguage.setAcceptLanguage(language);
        return acceptLanguage;
    }

    @Override
    public AlertInfoHeader createAlertInfoHeader(URI alertInfo) {
        if (alertInfo == null) {
            throw new NullPointerException("null arg alertInfo");
        }
        AlertInfo a = new AlertInfo();
        a.setAlertInfo(alertInfo);
        return a;
    }

    @Override
    public AllowEventsHeader createAllowEventsHeader(String eventType) throws ParseException {
        if (eventType == null) {
            throw new NullPointerException("null arg eventType");
        }
        AllowEvents allowEvents = new AllowEvents();
        allowEvents.setEventType(eventType);
        return allowEvents;
    }

    @Override
    public AllowHeader createAllowHeader(String method) throws ParseException {
        if (method == null) {
            throw new NullPointerException("null arg method");
        }
        Allow allow = new Allow();
        allow.setMethod(method);
        return allow;
    }

    @Override
    public AuthenticationInfoHeader createAuthenticationInfoHeader(String response) throws ParseException {
        if (response == null) {
            throw new NullPointerException("null arg response");
        }
        AuthenticationInfo auth = new AuthenticationInfo();
        auth.setResponse(response);
        return auth;
    }

    @Override
    public AuthorizationHeader createAuthorizationHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("null arg scheme ");
        }
        Authorization auth = new Authorization();
        auth.setScheme(scheme);
        return auth;
    }

    @Override
    public CSeqHeader createCSeqHeader(long sequenceNumber, String method) throws ParseException, InvalidArgumentException {
        if (sequenceNumber < 0L) {
            throw new InvalidArgumentException("bad arg " + sequenceNumber);
        }
        if (method == null) {
            throw new NullPointerException("null arg method");
        }
        CSeq cseq = new CSeq();
        cseq.setMethod(method);
        cseq.setSeqNumber(sequenceNumber);
        return cseq;
    }

    @Override
    public CSeqHeader createCSeqHeader(int sequenceNumber, String method) throws ParseException, InvalidArgumentException {
        return this.createCSeqHeader((long)sequenceNumber, method);
    }

    @Override
    public CallIdHeader createCallIdHeader(String callId) throws ParseException {
        if (callId == null) {
            throw new NullPointerException("null arg callId");
        }
        CallID c = new CallID();
        c.setCallId(callId);
        return c;
    }

    @Override
    public CallInfoHeader createCallInfoHeader(URI callInfo) {
        if (callInfo == null) {
            throw new NullPointerException("null arg callInfo");
        }
        CallInfo c = new CallInfo();
        c.setInfo(callInfo);
        return c;
    }

    @Override
    public ContactHeader createContactHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null arg address");
        }
        Contact contact = new Contact();
        contact.setAddress(address);
        return contact;
    }

    @Override
    public ContactHeader createContactHeader() {
        Contact contact = new Contact();
        contact.setWildCardFlag(true);
        contact.setExpires(0);
        return contact;
    }

    @Override
    public ContentDispositionHeader createContentDispositionHeader(String contentDisposition) throws ParseException {
        if (contentDisposition == null) {
            throw new NullPointerException("null arg contentDisposition");
        }
        ContentDisposition c = new ContentDisposition();
        c.setDispositionType(contentDisposition);
        return c;
    }

    @Override
    public ContentEncodingHeader createContentEncodingHeader(String encoding) throws ParseException {
        if (encoding == null) {
            throw new NullPointerException("null encoding");
        }
        ContentEncoding c = new ContentEncoding();
        c.setEncoding(encoding);
        return c;
    }

    @Override
    public ContentLanguageHeader createContentLanguageHeader(Locale contentLanguage) {
        if (contentLanguage == null) {
            throw new NullPointerException("null arg contentLanguage");
        }
        ContentLanguage c = new ContentLanguage();
        c.setContentLanguage(contentLanguage);
        return c;
    }

    @Override
    public ContentLengthHeader createContentLengthHeader(int contentLength) throws InvalidArgumentException {
        if (contentLength < 0) {
            throw new InvalidArgumentException("bad contentLength");
        }
        ContentLength c = new ContentLength();
        c.setContentLength(contentLength);
        return c;
    }

    @Override
    public ContentTypeHeader createContentTypeHeader(String contentType, String contentSubType) throws ParseException {
        if (contentType == null || contentSubType == null) {
            throw new NullPointerException("null contentType or subType");
        }
        ContentType c = new ContentType();
        c.setContentType(contentType);
        c.setContentSubType(contentSubType);
        return c;
    }

    @Override
    public DateHeader createDateHeader(Calendar date) {
        SIPDateHeader d = new SIPDateHeader();
        if (date == null) {
            throw new NullPointerException("null date");
        }
        d.setDate(date);
        return d;
    }

    @Override
    public EventHeader createEventHeader(String eventType) throws ParseException {
        if (eventType == null) {
            throw new NullPointerException("null eventType");
        }
        Event event = new Event();
        event.setEventType(eventType);
        return event;
    }

    @Override
    public ExpiresHeader createExpiresHeader(int expires) throws InvalidArgumentException {
        if (expires < 0) {
            throw new InvalidArgumentException("bad value " + expires);
        }
        Expires e = new Expires();
        e.setExpires(expires);
        return e;
    }

    public ExtensionHeader createExtensionHeader(String name, String value) throws ParseException {
        if (name == null) {
            throw new NullPointerException("bad name");
        }
        ExtensionHeaderImpl ext = new ExtensionHeaderImpl();
        ext.setName(name);
        ext.setValue(value);
        return ext;
    }

    @Override
    public FromHeader createFromHeader(Address address, String tag) throws ParseException {
        if (address == null) {
            throw new NullPointerException("null address arg");
        }
        From from = new From();
        from.setAddress(address);
        if (tag != null) {
            from.setTag(tag);
        }
        return from;
    }

    @Override
    public InReplyToHeader createInReplyToHeader(String callId) throws ParseException {
        if (callId == null) {
            throw new NullPointerException("null callId arg");
        }
        InReplyTo inReplyTo = new InReplyTo();
        inReplyTo.setCallId(callId);
        return inReplyTo;
    }

    @Override
    public MaxForwardsHeader createMaxForwardsHeader(int maxForwards) throws InvalidArgumentException {
        if (maxForwards < 0 || maxForwards > 255) {
            throw new InvalidArgumentException("bad maxForwards arg " + maxForwards);
        }
        MaxForwards m = new MaxForwards();
        m.setMaxForwards(maxForwards);
        return m;
    }

    @Override
    public MimeVersionHeader createMimeVersionHeader(int majorVersion, int minorVersion) throws InvalidArgumentException {
        if (majorVersion < 0 || minorVersion < 0) {
            throw new InvalidArgumentException("bad major/minor version");
        }
        MimeVersion m = new MimeVersion();
        m.setMajorVersion(majorVersion);
        m.setMinorVersion(minorVersion);
        return m;
    }

    @Override
    public MinExpiresHeader createMinExpiresHeader(int minExpires) throws InvalidArgumentException {
        if (minExpires < 0) {
            throw new InvalidArgumentException("bad minExpires " + minExpires);
        }
        MinExpires min = new MinExpires();
        min.setExpires(minExpires);
        return min;
    }

    public ExtensionHeader createMinSEHeader(int expires) throws InvalidArgumentException {
        if (expires < 0) {
            throw new InvalidArgumentException("bad value " + expires);
        }
        MinSE e = new MinSE();
        e.setExpires(expires);
        return e;
    }

    @Override
    public OrganizationHeader createOrganizationHeader(String organization) throws ParseException {
        if (organization == null) {
            throw new NullPointerException("bad organization arg");
        }
        Organization o = new Organization();
        o.setOrganization(organization);
        return o;
    }

    @Override
    public PriorityHeader createPriorityHeader(String priority) throws ParseException {
        if (priority == null) {
            throw new NullPointerException("bad priority arg");
        }
        Priority p = new Priority();
        p.setPriority(priority);
        return p;
    }

    @Override
    public ProxyAuthenticateHeader createProxyAuthenticateHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("bad scheme arg");
        }
        ProxyAuthenticate p = new ProxyAuthenticate();
        p.setScheme(scheme);
        return p;
    }

    @Override
    public ProxyAuthorizationHeader createProxyAuthorizationHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("bad scheme arg");
        }
        ProxyAuthorization p = new ProxyAuthorization();
        p.setScheme(scheme);
        return p;
    }

    @Override
    public ProxyRequireHeader createProxyRequireHeader(String optionTag) throws ParseException {
        if (optionTag == null) {
            throw new NullPointerException("bad optionTag arg");
        }
        ProxyRequire p = new ProxyRequire();
        p.setOptionTag(optionTag);
        return p;
    }

    public RAckHeader createRAckHeader(long rSeqNumber, long cSeqNumber, String method) throws InvalidArgumentException, ParseException {
        if (method == null) {
            throw new NullPointerException("Bad method");
        }
        if (cSeqNumber < 0L || rSeqNumber < 0L) {
            throw new InvalidArgumentException("bad cseq/rseq arg");
        }
        RAck rack = new RAck();
        rack.setMethod(method);
        rack.setCSequenceNumber(cSeqNumber);
        rack.setRSequenceNumber(rSeqNumber);
        return rack;
    }

    @Override
    public RAckHeader createRAckHeader(int rSeqNumber, int cSeqNumber, String method) throws InvalidArgumentException, ParseException {
        return this.createRAckHeader((long)rSeqNumber, (long)cSeqNumber, method);
    }

    @Override
    public RSeqHeader createRSeqHeader(int sequenceNumber) throws InvalidArgumentException {
        return this.createRSeqHeader((long)sequenceNumber);
    }

    public RSeqHeader createRSeqHeader(long sequenceNumber) throws InvalidArgumentException {
        if (sequenceNumber < 0L) {
            throw new InvalidArgumentException("invalid sequenceNumber arg " + sequenceNumber);
        }
        RSeq rseq = new RSeq();
        rseq.setSeqNumber(sequenceNumber);
        return rseq;
    }

    @Override
    public ReasonHeader createReasonHeader(String protocol, int cause, String text) throws InvalidArgumentException, ParseException {
        if (protocol == null) {
            throw new NullPointerException("bad protocol arg");
        }
        if (cause < 0) {
            throw new InvalidArgumentException("bad cause");
        }
        Reason reason = new Reason();
        reason.setProtocol(protocol);
        reason.setCause(cause);
        reason.setText(text);
        return reason;
    }

    @Override
    public RecordRouteHeader createRecordRouteHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("Null argument!");
        }
        RecordRoute recordRoute = new RecordRoute();
        recordRoute.setAddress(address);
        return recordRoute;
    }

    @Override
    public ReplyToHeader createReplyToHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        ReplyTo replyTo = new ReplyTo();
        replyTo.setAddress(address);
        return replyTo;
    }

    @Override
    public RequireHeader createRequireHeader(String optionTag) throws ParseException {
        if (optionTag == null) {
            throw new NullPointerException("null optionTag");
        }
        Require require = new Require();
        require.setOptionTag(optionTag);
        return require;
    }

    @Override
    public RetryAfterHeader createRetryAfterHeader(int retryAfter) throws InvalidArgumentException {
        if (retryAfter < 0) {
            throw new InvalidArgumentException("bad retryAfter arg");
        }
        RetryAfter r = new RetryAfter();
        r.setRetryAfter(retryAfter);
        return r;
    }

    @Override
    public RouteHeader createRouteHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address arg");
        }
        Route route = new Route();
        route.setAddress(address);
        return route;
    }

    @Override
    public ServerHeader createServerHeader(List product) throws ParseException {
        if (product == null) {
            throw new NullPointerException("null productList arg");
        }
        Server server = new Server();
        server.setProduct(product);
        return server;
    }

    @Override
    public SubjectHeader createSubjectHeader(String subject) throws ParseException {
        if (subject == null) {
            throw new NullPointerException("null subject arg");
        }
        Subject s = new Subject();
        s.setSubject(subject);
        return s;
    }

    @Override
    public SubscriptionStateHeader createSubscriptionStateHeader(String subscriptionState) throws ParseException {
        if (subscriptionState == null) {
            throw new NullPointerException("null subscriptionState arg");
        }
        SubscriptionState s = new SubscriptionState();
        s.setState(subscriptionState);
        return s;
    }

    @Override
    public SupportedHeader createSupportedHeader(String optionTag) throws ParseException {
        if (optionTag == null) {
            throw new NullPointerException("null optionTag arg");
        }
        Supported supported = new Supported();
        supported.setOptionTag(optionTag);
        return supported;
    }

    @Override
    public TimeStampHeader createTimeStampHeader(float timeStamp) throws InvalidArgumentException {
        if (timeStamp < 0.0f) {
            throw new IllegalArgumentException("illegal timeStamp");
        }
        TimeStamp t = new TimeStamp();
        t.setTimeStamp(timeStamp);
        return t;
    }

    @Override
    public ToHeader createToHeader(Address address, String tag) throws ParseException {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        To to = new To();
        to.setAddress(address);
        if (tag != null) {
            to.setTag(tag);
        }
        return to;
    }

    @Override
    public UnsupportedHeader createUnsupportedHeader(String optionTag) throws ParseException {
        if (optionTag == null) {
            throw new NullPointerException(optionTag);
        }
        Unsupported unsupported = new Unsupported();
        unsupported.setOptionTag(optionTag);
        return unsupported;
    }

    @Override
    public UserAgentHeader createUserAgentHeader(List product) throws ParseException {
        if (product == null) {
            throw new NullPointerException("null user agent");
        }
        UserAgent userAgent = new UserAgent();
        userAgent.setProduct(product);
        return userAgent;
    }

    @Override
    public ViaHeader createViaHeader(String host, int port, String transport, String branch) throws ParseException, InvalidArgumentException {
        if (host == null || transport == null) {
            throw new NullPointerException("null arg");
        }
        Via via = new Via();
        if (branch != null) {
            via.setBranch(branch);
        }
        if (host.indexOf(58) >= 0 && host.indexOf(91) < 0) {
            int zoneStart;
            if (this.stripAddressScopeZones && (zoneStart = host.indexOf(37)) != -1) {
                host = host.substring(0, zoneStart);
            }
            host = '[' + host + ']';
        }
        via.setHost(host);
        via.setPort(port);
        via.setTransport(transport);
        return via;
    }

    @Override
    public WWWAuthenticateHeader createWWWAuthenticateHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("null scheme");
        }
        WWWAuthenticate www = new WWWAuthenticate();
        www.setScheme(scheme);
        return www;
    }

    @Override
    public WarningHeader createWarningHeader(String agent, int code, String comment) throws ParseException, InvalidArgumentException {
        if (agent == null) {
            throw new NullPointerException("null arg");
        }
        Warning warning = new Warning();
        warning.setAgent(agent);
        warning.setCode(code);
        warning.setText(comment);
        return warning;
    }

    @Override
    public ErrorInfoHeader createErrorInfoHeader(URI errorInfo) {
        if (errorInfo == null) {
            throw new NullPointerException("null arg");
        }
        return new ErrorInfo((GenericURI)errorInfo);
    }

    @Override
    public Header createHeader(String headerText) throws ParseException {
        StringMsgParser smp = new StringMsgParser();
        SIPHeader sipHeader = StringMsgParser.parseSIPHeader(headerText.trim());
        if (sipHeader instanceof SIPHeaderList) {
            if (((SIPHeaderList)sipHeader).size() > 1) {
                throw new ParseException("Only singleton allowed " + headerText, 0);
            }
            if (((SIPHeaderList)sipHeader).size() == 0) {
                try {
                    return (Header)((SIPHeaderList)sipHeader).getMyClass().newInstance();
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return ((SIPHeaderList)sipHeader).getFirst();
        }
        return sipHeader;
    }

    @Override
    public Header createHeader(String headerName, String headerValue) throws ParseException {
        if (headerName == null) {
            throw new NullPointerException("header name is null");
        }
        String hdrText = headerName + ":" + headerValue;
        return this.createHeader(hdrText);
    }

    @Override
    public List createHeaders(String headers) throws ParseException {
        if (headers == null) {
            throw new NullPointerException("null arg!");
        }
        StringMsgParser smp = new StringMsgParser();
        SIPHeader shdr = StringMsgParser.parseSIPHeader(headers);
        if (shdr instanceof SIPHeaderList) {
            return (SIPHeaderList)shdr;
        }
        throw new ParseException("List of headers of this type is not allowed in a message", 0);
    }

    @Override
    public ReferToHeader createReferToHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        ReferTo referTo = new ReferTo();
        referTo.setAddress(address);
        return referTo;
    }

    @Override
    public ReferredByHeader createReferredByHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        ReferredBy referredBy = new ReferredBy();
        referredBy.setAddress(address);
        return referredBy;
    }

    @Override
    public ReplacesHeader createReplacesHeader(String callId, String toTag, String fromTag) throws ParseException {
        Replaces replaces = new Replaces();
        replaces.setCallId(callId);
        replaces.setFromTag(fromTag);
        replaces.setToTag(toTag);
        return replaces;
    }

    @Override
    public JoinHeader createJoinHeader(String callId, String toTag, String fromTag) throws ParseException {
        Join join = new Join();
        join.setCallId(callId);
        join.setFromTag(fromTag);
        join.setToTag(toTag);
        return join;
    }

    @Override
    public SIPETagHeader createSIPETagHeader(String etag) throws ParseException {
        return new SIPETag(etag);
    }

    @Override
    public SIPIfMatchHeader createSIPIfMatchHeader(String etag) throws ParseException {
        return new SIPIfMatch(etag);
    }

    @Override
    public PAccessNetworkInfoHeader createPAccessNetworkInfoHeader() {
        PAccessNetworkInfo accessNetworkInfo = new PAccessNetworkInfo();
        return accessNetworkInfo;
    }

    @Override
    public PAssertedIdentityHeader createPAssertedIdentityHeader(Address address) throws NullPointerException, ParseException {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        PAssertedIdentity assertedIdentity = new PAssertedIdentity();
        assertedIdentity.setAddress(address);
        return assertedIdentity;
    }

    @Override
    public PAssociatedURIHeader createPAssociatedURIHeader(Address assocURI) {
        if (assocURI == null) {
            throw new NullPointerException("null associatedURI!");
        }
        PAssociatedURI associatedURI = new PAssociatedURI();
        associatedURI.setAddress(assocURI);
        return associatedURI;
    }

    @Override
    public PCalledPartyIDHeader createPCalledPartyIDHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        PCalledPartyID calledPartyID = new PCalledPartyID();
        calledPartyID.setAddress(address);
        return calledPartyID;
    }

    @Override
    public PChargingFunctionAddressesHeader createPChargingFunctionAddressesHeader() {
        PChargingFunctionAddresses cfa = new PChargingFunctionAddresses();
        return cfa;
    }

    @Override
    public PChargingVectorHeader createChargingVectorHeader(String icid) throws ParseException {
        if (icid == null) {
            throw new NullPointerException("null icid arg!");
        }
        PChargingVector chargingVector = new PChargingVector();
        chargingVector.setICID(icid);
        return chargingVector;
    }

    @Override
    public PMediaAuthorizationHeader createPMediaAuthorizationHeader(String token) throws InvalidArgumentException, ParseException {
        if (token == null || token == "") {
            throw new InvalidArgumentException("The Media-Authorization-Token parameter is null or empty");
        }
        PMediaAuthorization mediaAuthorization = new PMediaAuthorization();
        mediaAuthorization.setMediaAuthorizationToken(token);
        return mediaAuthorization;
    }

    @Override
    public PPreferredIdentityHeader createPPreferredIdentityHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        PPreferredIdentity preferredIdentity = new PPreferredIdentity();
        preferredIdentity.setAddress(address);
        return preferredIdentity;
    }

    @Override
    public PVisitedNetworkIDHeader createPVisitedNetworkIDHeader() {
        PVisitedNetworkID visitedNetworkID = new PVisitedNetworkID();
        return visitedNetworkID;
    }

    @Override
    public PathHeader createPathHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        Path path = new Path();
        path.setAddress(address);
        return path;
    }

    @Override
    public PrivacyHeader createPrivacyHeader(String privacyType) {
        if (privacyType == null) {
            throw new NullPointerException("null privacyType arg");
        }
        Privacy privacy = new Privacy(privacyType);
        return privacy;
    }

    @Override
    public ServiceRouteHeader createServiceRouteHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        ServiceRoute serviceRoute = new ServiceRoute();
        serviceRoute.setAddress(address);
        return serviceRoute;
    }

    @Override
    public SecurityServerHeader createSecurityServerHeader() {
        SecurityServer secServer = new SecurityServer();
        return secServer;
    }

    @Override
    public SecurityClientHeader createSecurityClientHeader() {
        SecurityClient secClient = new SecurityClient();
        return secClient;
    }

    @Override
    public SecurityVerifyHeader createSecurityVerifyHeader() {
        SecurityVerify secVerify = new SecurityVerify();
        return secVerify;
    }

    @Override
    public PUserDatabaseHeader createPUserDatabaseHeader(String databaseName) {
        if (databaseName == null || databaseName.equals(" ")) {
            throw new NullPointerException("Database name is null");
        }
        PUserDatabase pUserDatabase = new PUserDatabase();
        pUserDatabase.setDatabaseName(databaseName);
        return pUserDatabase;
    }

    @Override
    public PProfileKeyHeader createPProfileKeyHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("Address is null");
        }
        PProfileKey pProfileKey = new PProfileKey();
        pProfileKey.setAddress(address);
        return pProfileKey;
    }

    @Override
    public PServedUserHeader createPServedUserHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("Address is null");
        }
        PServedUser psu = new PServedUser();
        psu.setAddress(address);
        return psu;
    }

    @Override
    public PPreferredServiceHeader createPPreferredServiceHeader() {
        PPreferredService pps = new PPreferredService();
        return pps;
    }

    @Override
    public PAssertedServiceHeader createPAssertedServiceHeader() {
        PAssertedService pas = new PAssertedService();
        return pas;
    }

    @Override
    public SessionExpiresHeader createSessionExpiresHeader(int expires) throws InvalidArgumentException {
        if (expires < 0) {
            throw new InvalidArgumentException("bad value " + expires);
        }
        SessionExpires s = new SessionExpires();
        s.setExpires(expires);
        return s;
    }

    @Override
    public SipRequestLine createRequestLine(String requestLine) throws ParseException {
        RequestLineParser requestLineParser = new RequestLineParser(requestLine);
        return requestLineParser.parse();
    }

    @Override
    public SipStatusLine createStatusLine(String statusLine) throws ParseException {
        StatusLineParser statusLineParser = new StatusLineParser(statusLine);
        return statusLineParser.parse();
    }

    @Override
    public ReferencesHeader createReferencesHeader(String callId, String rel) throws ParseException {
        References retval = new References();
        retval.setCallId(callId);
        retval.setRel(rel);
        return retval;
    }
}

