/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header;

import android.gov.nist.javax.sip.header.SIPHeader;
import android.javax.sip.InvalidArgumentException;
import android.javax.sip.header.RAckHeader;
import java.text.ParseException;

public class RAck
extends SIPHeader
implements RAckHeader {
    private static final long serialVersionUID = 743999286077404118L;
    protected long cSeqNumber;
    protected long rSeqNumber;
    protected String method;

    public RAck() {
        super("RAck");
    }

    @Override
    public StringBuilder encodeBody(StringBuilder buffer) {
        return buffer.append(this.rSeqNumber).append(" ").append(this.cSeqNumber).append(" ").append(this.method);
    }

    @Override
    public int getCSeqNumber() {
        return (int)this.cSeqNumber;
    }

    public long getCSeqNumberLong() {
        return this.cSeqNumber;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public int getRSeqNumber() {
        return (int)this.rSeqNumber;
    }

    @Override
    public void setCSeqNumber(int cSeqNumber) throws InvalidArgumentException {
        this.setCSequenceNumber(cSeqNumber);
    }

    @Override
    public void setMethod(String method) throws ParseException {
        this.method = method;
    }

    public long getCSequenceNumber() {
        return this.cSeqNumber;
    }

    public long getRSequenceNumber() {
        return this.rSeqNumber;
    }

    public void setCSequenceNumber(long cSeqNumber) throws InvalidArgumentException {
        if (cSeqNumber <= 0L || cSeqNumber > 0x80000000L) {
            throw new InvalidArgumentException("Bad CSeq # " + cSeqNumber);
        }
        this.cSeqNumber = cSeqNumber;
    }

    @Override
    public void setRSeqNumber(int rSeqNumber) throws InvalidArgumentException {
        this.setRSequenceNumber(rSeqNumber);
    }

    public void setRSequenceNumber(long rSeqNumber) throws InvalidArgumentException {
        if (rSeqNumber <= 0L || this.cSeqNumber > 0x80000000L) {
            throw new InvalidArgumentException("Bad rSeq # " + rSeqNumber);
        }
        this.rSeqNumber = rSeqNumber;
    }
}

