/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header;

import android.gov.nist.javax.sip.Utils;
import android.gov.nist.javax.sip.header.ParametersHeader;
import android.javax.sip.InvalidArgumentException;
import android.javax.sip.header.ReasonHeader;
import java.text.ParseException;

public class Reason
extends ParametersHeader
implements ReasonHeader {
    private static final long serialVersionUID = -8903376965568297388L;
    public final String TEXT = "text";
    public final String CAUSE = "cause";
    protected String protocol;

    @Override
    public int getCause() {
        return this.getParameterAsInt("cause");
    }

    @Override
    public void setCause(int cause) throws InvalidArgumentException {
        this.parameters.set("cause", cause);
    }

    @Override
    public void setProtocol(String protocol) throws ParseException {
        this.protocol = protocol;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setText(String text) throws ParseException {
        if (text != null && text.trim().length() > 0) {
            if (text.charAt(0) != '\"') {
                text = Utils.getQuotedString(text);
            }
            this.parameters.set("text", text);
        }
    }

    @Override
    public String getText() {
        return this.parameters.getParameter("text");
    }

    public Reason() {
        super("Reason");
    }

    @Override
    public String getName() {
        return "Reason";
    }

    @Override
    public StringBuilder encodeBody(StringBuilder buffer) {
        buffer.append(this.protocol);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            buffer = buffer.append(";");
            buffer = this.parameters.encode(buffer);
        }
        return buffer;
    }
}

