/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header;

import android.gov.nist.core.HostPort;
import android.gov.nist.javax.sip.address.AddressImpl;
import android.gov.nist.javax.sip.header.AddressParametersHeader;
import android.javax.sip.header.ReplyToHeader;

public final class ReplyTo
extends AddressParametersHeader
implements ReplyToHeader {
    private static final long serialVersionUID = -9103698729465531373L;

    public ReplyTo() {
        super("Reply-To");
    }

    public ReplyTo(AddressImpl address) {
        super("Reply-To");
        this.address = address;
    }

    @Override
    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody(new StringBuilder()).toString() + "\r\n";
    }

    @Override
    public StringBuilder encodeBody(StringBuilder retval) {
        if (this.address.getAddressType() == 2) {
            retval.append("<");
        }
        this.address.encode(retval);
        if (this.address.getAddressType() == 2) {
            retval.append(">");
        }
        if (!this.parameters.isEmpty()) {
            retval.append(";");
            this.parameters.encode(retval);
        }
        return retval;
    }

    public HostPort getHostPort() {
        return this.address.getHostPort();
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }
}

