/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header;

import android.gov.nist.javax.sip.header.ParametersHeader;
import android.javax.sip.InvalidArgumentException;
import android.javax.sip.header.RetryAfterHeader;
import java.text.ParseException;

public class RetryAfter
extends ParametersHeader
implements RetryAfterHeader {
    private static final long serialVersionUID = -1029458515616146140L;
    public static final String DURATION = "duration";
    protected Integer retryAfter = new Integer(0);
    protected String comment;

    public RetryAfter() {
        super("Retry-After");
    }

    @Override
    public StringBuilder encodeBody(StringBuilder retval) {
        if (this.retryAfter != null) {
            retval.append(this.retryAfter);
        }
        if (this.comment != null) {
            retval.append(" (" + this.comment + ")");
        }
        if (!this.parameters.isEmpty()) {
            retval.append(";");
            this.parameters.encode(retval);
        }
        return retval;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removeComment() {
        this.comment = null;
    }

    public void removeDuration() {
        super.removeParameter(DURATION);
    }

    @Override
    public void setRetryAfter(int retryAfter) throws InvalidArgumentException {
        if (retryAfter < 0) {
            throw new InvalidArgumentException("invalid parameter " + retryAfter);
        }
        this.retryAfter = retryAfter;
    }

    @Override
    public int getRetryAfter() {
        return this.retryAfter;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) throws ParseException {
        if (comment == null) {
            throw new NullPointerException("the comment parameter is null");
        }
        this.comment = comment;
    }

    @Override
    public void setDuration(int duration) throws InvalidArgumentException {
        if (duration < 0) {
            throw new InvalidArgumentException("the duration parameter is <0");
        }
        this.setParameter(DURATION, duration);
    }

    @Override
    public int getDuration() {
        if (this.getParameter(DURATION) == null) {
            return -1;
        }
        return super.getParameterAsInt(DURATION);
    }
}

