/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header;

import android.gov.nist.core.HostPort;
import android.gov.nist.javax.sip.header.AddressParametersHeader;
import android.gov.nist.javax.sip.header.From;
import android.gov.nist.javax.sip.parser.Parser;
import android.javax.sip.header.ToHeader;
import java.text.ParseException;

public final class To
extends AddressParametersHeader
implements ToHeader {
    private static final long serialVersionUID = -4057413800584586316L;

    public To() {
        super("To", true);
    }

    public To(From from) {
        super("To");
        this.setAddress(from.address);
        this.setParameters(from.parameters);
    }

    @Override
    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.address != null) {
            if (this.address.getAddressType() == 2) {
                buffer.append("<");
            }
            this.address.encode(buffer);
            if (this.address.getAddressType() == 2) {
                buffer.append(">");
            }
            if (!this.parameters.isEmpty()) {
                buffer.append(";");
                this.parameters.encode(buffer);
            }
        }
        return buffer;
    }

    public HostPort getHostPort() {
        if (this.address == null) {
            return null;
        }
        return this.address.getHostPort();
    }

    public String getDisplayName() {
        if (this.address == null) {
            return null;
        }
        return this.address.getDisplayName();
    }

    @Override
    public String getTag() {
        if (this.parameters == null) {
            return null;
        }
        return this.getParameter("tag");
    }

    public boolean hasTag() {
        if (this.parameters == null) {
            return false;
        }
        return this.hasParameter("tag");
    }

    public void removeTag() {
        if (this.parameters != null) {
            this.parameters.delete("tag");
        }
    }

    @Override
    public void setTag(String t) throws ParseException {
        Parser.checkToken(t);
        this.setParameter("tag", t);
    }

    public String getUserAtHostPort() {
        if (this.address == null) {
            return null;
        }
        return this.address.getUserAtHostPort();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ToHeader && super.equals(other);
    }
}

