/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.header.extensions;

import android.gov.nist.javax.sip.header.ParametersHeader;
import android.gov.nist.javax.sip.header.extensions.SessionExpiresHeader;
import android.javax.sip.InvalidArgumentException;
import android.javax.sip.header.ExtensionHeader;
import java.text.ParseException;

public final class SessionExpires
extends ParametersHeader
implements ExtensionHeader,
SessionExpiresHeader {
    private static final long serialVersionUID = 8765762413224043300L;
    public static final String NAME = "Session-Expires";
    public int expires;
    public static final String REFRESHER = "refresher";

    public SessionExpires() {
        super(NAME);
    }

    @Override
    public int getExpires() {
        return this.expires;
    }

    @Override
    public void setExpires(int expires) throws InvalidArgumentException {
        if (expires < 0) {
            throw new InvalidArgumentException("bad argument " + expires);
        }
        this.expires = expires;
    }

    @Override
    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder retval) {
        retval.append(Integer.toString(this.expires));
        if (!this.parameters.isEmpty()) {
            retval.append(";");
            this.parameters.encode(retval);
        }
        return retval;
    }

    @Override
    public String getRefresher() {
        return this.parameters.getParameter(REFRESHER);
    }

    @Override
    public void setRefresher(String refresher) {
        this.parameters.set(REFRESHER, refresher);
    }
}

