/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.message;

import android.gov.nist.core.GenericObject;
import android.gov.nist.core.GenericObjectList;
import java.lang.reflect.Field;

public abstract class MessageObject
extends GenericObject {
    @Override
    public abstract String encode();

    @Override
    public void dbgPrint() {
        super.dbgPrint();
    }

    @Override
    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> myclass = this.getClass();
        this.sprint(myclass.getName());
        this.sprint("{");
        Field[] fields = myclass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int modifier = f.getModifiers();
            if (modifier == 2) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
            this.sprint(fieldName + ":");
            try {
                if (fieldType.isPrimitive()) {
                    String fname = fieldType.toString();
                    this.sprint(fname + ":");
                    if (fname.compareTo("int") == 0) {
                        int intfield = f.getInt(this);
                        this.sprint(intfield);
                        continue;
                    }
                    if (fname.compareTo("short") == 0) {
                        short shortField = f.getShort(this);
                        this.sprint(shortField);
                        continue;
                    }
                    if (fname.compareTo("char") == 0) {
                        char charField = f.getChar(this);
                        this.sprint(charField);
                        continue;
                    }
                    if (fname.compareTo("long") == 0) {
                        long longField = f.getLong(this);
                        this.sprint(longField);
                        continue;
                    }
                    if (fname.compareTo("boolean") == 0) {
                        boolean booleanField = f.getBoolean(this);
                        this.sprint(booleanField);
                        continue;
                    }
                    if (fname.compareTo("double") == 0) {
                        double doubleField = f.getDouble(this);
                        this.sprint(doubleField);
                        continue;
                    }
                    if (fname.compareTo("float") != 0) continue;
                    float floatField = f.getFloat(this);
                    this.sprint(floatField);
                    continue;
                }
                if (GenericObject.class.isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObject)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (GenericObjectList.class.isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObjectList)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (f.get(this) != null) {
                    this.sprint(f.get(this).getClass().getName() + ":");
                } else {
                    this.sprint(fieldType.getName() + ":");
                }
                this.sprint("{");
                if (f.get(this) != null) {
                    this.sprint(f.get(this).toString());
                } else {
                    this.sprint("<null>");
                }
                this.sprint("}");
                continue;
            }
            catch (IllegalAccessException ex1) {
                // empty catch block
            }
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    protected MessageObject() {
    }

    public String dbgPrint(int indent) {
        int save = this.indentation;
        this.indentation = indent;
        String retval = this.toString();
        this.indentation = save;
        return retval;
    }
}

