/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.parser;

import android.gov.nist.core.Debug;
import android.gov.nist.javax.sip.header.CSeq;
import android.gov.nist.javax.sip.header.SIPHeader;
import android.gov.nist.javax.sip.message.SIPRequest;
import android.gov.nist.javax.sip.parser.HeaderParser;
import android.gov.nist.javax.sip.parser.Lexer;
import android.javax.sip.InvalidArgumentException;
import java.text.ParseException;

public class CSeqParser
extends HeaderParser {
    public CSeqParser(String cseq) {
        super(cseq);
    }

    protected CSeqParser(Lexer lexer) {
        super(lexer);
    }

    @Override
    public SIPHeader parse() throws ParseException {
        try {
            CSeq c = new CSeq();
            this.headerName(2094);
            String number = this.lexer.number();
            c.setSeqNumber(Long.parseLong(number));
            this.lexer.SPorHT();
            String m = SIPRequest.getCannonicalName(this.method()).intern();
            c.setMethod(m);
            this.lexer.SPorHT();
            this.lexer.match(10);
            return c;
        }
        catch (NumberFormatException ex) {
            Debug.printStackTrace(ex);
            throw this.createParseException("Number format exception");
        }
        catch (InvalidArgumentException ex) {
            Debug.printStackTrace(ex);
            throw this.createParseException(ex.getMessage());
        }
    }
}

