/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.parser;

import android.gov.nist.core.NameValue;
import android.gov.nist.core.Token;
import android.gov.nist.javax.sip.header.SIPHeader;
import android.gov.nist.javax.sip.header.SubscriptionState;
import android.gov.nist.javax.sip.parser.HeaderParser;
import android.gov.nist.javax.sip.parser.Lexer;
import android.javax.sip.InvalidArgumentException;
import java.text.ParseException;

public class SubscriptionStateParser
extends HeaderParser {
    public SubscriptionStateParser(String subscriptionState) {
        super(subscriptionState);
    }

    protected SubscriptionStateParser(Lexer lexer) {
        super(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIPHeader parse() throws ParseException {
        if (debug) {
            this.dbg_enter("SubscriptionStateParser.parse");
        }
        SubscriptionState subscriptionState = new SubscriptionState();
        try {
            this.headerName(2104);
            subscriptionState.setHeaderName("Subscription-State");
            this.lexer.match(4095);
            Token token = this.lexer.getNextToken();
            subscriptionState.setState(token.getTokenValue());
            while (this.lexer.lookAhead(0) == ';') {
                this.lexer.match(59);
                this.lexer.SPorHT();
                NameValue nv = this.nameValue('=');
                if (nv.getName().equalsIgnoreCase("reason")) {
                    subscriptionState.setReasonCode(nv.getValue());
                } else if (nv.getName().equalsIgnoreCase("expires")) {
                    try {
                        int expires = Integer.parseInt(nv.getValue());
                        subscriptionState.setExpires(expires);
                    }
                    catch (NumberFormatException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                    catch (InvalidArgumentException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                } else if (nv.getName().equalsIgnoreCase("retry-after")) {
                    try {
                        int retryAfter = Integer.parseInt(nv.getValue());
                        subscriptionState.setRetryAfter(retryAfter);
                    }
                    catch (NumberFormatException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                    catch (InvalidArgumentException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                } else {
                    subscriptionState.setParameter(nv);
                }
                this.lexer.SPorHT();
            }
        }
        finally {
            if (debug) {
                this.dbg_leave("SubscriptionStateParser.parse");
            }
        }
        return subscriptionState;
    }
}

