/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.parser;

import android.gov.nist.core.HostNameParser;
import android.gov.nist.core.HostPort;
import android.gov.nist.core.NameValue;
import android.gov.nist.core.Token;
import android.gov.nist.javax.sip.header.Protocol;
import android.gov.nist.javax.sip.header.SIPHeader;
import android.gov.nist.javax.sip.header.Via;
import android.gov.nist.javax.sip.header.ViaList;
import android.gov.nist.javax.sip.parser.HeaderParser;
import android.gov.nist.javax.sip.parser.Lexer;
import java.text.ParseException;

public class ViaParser
extends HeaderParser {
    public ViaParser(String via) {
        super(via);
    }

    public ViaParser(Lexer lexer) {
        super(lexer);
    }

    private void parseVia(Via v) throws ParseException {
        this.lexer.match(4095);
        Token protocolName = this.lexer.getNextToken();
        this.lexer.SPorHT();
        this.lexer.match(47);
        this.lexer.SPorHT();
        this.lexer.match(4095);
        this.lexer.SPorHT();
        Token protocolVersion = this.lexer.getNextToken();
        this.lexer.SPorHT();
        this.lexer.match(47);
        this.lexer.SPorHT();
        this.lexer.match(4095);
        this.lexer.SPorHT();
        Token transport = this.lexer.getNextToken();
        this.lexer.SPorHT();
        Protocol protocol = new Protocol();
        protocol.setProtocolName(protocolName.getTokenValue());
        protocol.setProtocolVersion(protocolVersion.getTokenValue());
        protocol.setTransport(transport.getTokenValue());
        v.setSentProtocol(protocol);
        HostNameParser hnp = new HostNameParser(this.getLexer());
        HostPort hostPort = hnp.hostPort(true);
        v.setSentBy(hostPort);
        this.lexer.SPorHT();
        while (this.lexer.lookAhead(0) == ';') {
            String branchId;
            this.lexer.consume(1);
            this.lexer.SPorHT();
            NameValue nameValue = this.nameValue();
            String name = nameValue.getName();
            if (name.equals("branch") && (branchId = (String)nameValue.getValueAsObject()) == null) {
                throw new ParseException("null branch Id", this.lexer.getPtr());
            }
            v.setParameter(nameValue);
            this.lexer.SPorHT();
        }
        if (this.lexer.lookAhead(0) == '(') {
            this.lexer.selectLexer("charLexer");
            this.lexer.consume(1);
            StringBuilder comment = new StringBuilder();
            while (true) {
                char ch;
                if ((ch = this.lexer.lookAhead(0)) == ')') {
                    this.lexer.consume(1);
                    break;
                }
                if (ch == '\\') {
                    Token tok = this.lexer.getNextToken();
                    comment.append(tok.getTokenValue());
                    this.lexer.consume(1);
                    tok = this.lexer.getNextToken();
                    comment.append(tok.getTokenValue());
                    this.lexer.consume(1);
                    continue;
                }
                if (ch == '\n') break;
                comment.append(ch);
                this.lexer.consume(1);
            }
            v.setComment(comment.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NameValue nameValue() throws ParseException {
        if (debug) {
            this.dbg_enter("nameValue");
        }
        try {
            this.lexer.match(4095);
            Token name = this.lexer.getNextToken();
            this.lexer.SPorHT();
            try {
                boolean quoted = false;
                char la = this.lexer.lookAhead(0);
                if (la == '=') {
                    this.lexer.consume(1);
                    this.lexer.SPorHT();
                    String str = null;
                    if (name.getTokenValue().compareToIgnoreCase("received") == 0) {
                        str = this.lexer.byteStringNoSemicolon();
                    } else if (this.lexer.lookAhead(0) == '\"') {
                        str = this.lexer.quotedString();
                        quoted = true;
                    } else {
                        this.lexer.match(4095);
                        Token value = this.lexer.getNextToken();
                        str = value.getTokenValue();
                    }
                    NameValue nv = new NameValue(name.getTokenValue().toLowerCase(), str);
                    if (quoted) {
                        nv.setQuotedValue();
                    }
                    NameValue nameValue = nv;
                    return nameValue;
                }
                NameValue nameValue = new NameValue(name.getTokenValue().toLowerCase(), null);
                return nameValue;
            }
            catch (ParseException ex) {
                NameValue nameValue = new NameValue(name.getTokenValue(), null);
                return nameValue;
            }
        }
        finally {
            if (debug) {
                this.dbg_leave("nameValue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIPHeader parse() throws ParseException {
        if (debug) {
            this.dbg_enter("parse");
        }
        try {
            ViaList viaList = new ViaList();
            this.lexer.match(2064);
            this.lexer.SPorHT();
            this.lexer.match(58);
            this.lexer.SPorHT();
            do {
                Via v = new Via();
                this.parseVia(v);
                viaList.add(v);
                this.lexer.SPorHT();
                if (this.lexer.lookAhead(0) != ',') continue;
                this.lexer.consume(1);
                this.lexer.SPorHT();
            } while (this.lexer.lookAhead(0) != '\n');
            this.lexer.match(10);
            ViaList viaList2 = viaList;
            return viaList2;
        }
        finally {
            if (debug) {
                this.dbg_leave("parse");
            }
        }
    }
}

