/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import java.nio.ByteBuffer;

public class ByteBufferFactory {
    private static StackLogger logger = CommonLogger.getLogger(ByteBufferFactory.class);
    private static ByteBufferFactory instance = new ByteBufferFactory();
    private boolean useDirect = true;

    public static ByteBufferFactory getInstance() {
        return instance;
    }

    public ByteBuffer allocateDirect(int capacity) {
        if (logger.isLoggingEnabled(32)) {
            logger.logTrace("Allocating direct buffer " + capacity);
        }
        return this.useDirect ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public ByteBuffer allocate(int capacity) {
        if (logger.isLoggingEnabled(32)) {
            logger.logTrace("Allocating buffer " + capacity);
        }
        return ByteBuffer.allocate(capacity);
    }

    public void setUseDirect(boolean useDirect) {
        if (logger.isLoggingEnabled(32)) {
            logger.logTrace("Direct buffers are " + (useDirect ? "enabled" : "disabled"));
        }
        this.useDirect = useDirect;
    }
}

