/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack;

import android.gov.nist.javax.sip.SipStackImpl;
import android.gov.nist.javax.sip.stack.CallAnalyzer;
import android.gov.nist.javax.sip.stack.SIPEventInterceptor;
import android.javax.sip.SipStack;
import android.javax.sip.message.Message;
import java.util.Properties;

public class CallAnalysisInterceptor
implements SIPEventInterceptor {
    private CallAnalyzer callAnalyzer;
    private static final CallAnalyzer.MetricReference interceptorCheckpoint = new CallAnalyzer.MetricReference("ick");

    @Override
    public void afterMessage(Message message) {
        this.callAnalyzer.leave(interceptorCheckpoint);
    }

    @Override
    public void beforeMessage(Message message) {
        this.callAnalyzer.enter(interceptorCheckpoint);
    }

    @Override
    public void destroy() {
        this.callAnalyzer.stop();
        this.callAnalyzer = null;
    }

    @Override
    public void init(SipStack stack) {
        this.callAnalyzer = new CallAnalyzer((SipStackImpl)stack);
        Properties props = ((SipStackImpl)stack).getConfigurationProperties();
        Long checkingInterval = Long.parseLong(props.getProperty(CallAnalysisInterceptor.class.getName() + ".checkingInterval", "1000"));
        Long minStuckTime = Long.parseLong(props.getProperty(CallAnalysisInterceptor.class.getName() + ".minStuckTIme", "4000"));
        Long minTimeBetweenDumps = Long.parseLong(props.getProperty(CallAnalysisInterceptor.class.getName() + ".minTimeBetweenDumps", "2000"));
        CallAnalyzer.MetricAnalysisConfiguration config = new CallAnalyzer.MetricAnalysisConfiguration(checkingInterval, minTimeBetweenDumps, minStuckTime);
        this.callAnalyzer.configure(interceptorCheckpoint, config);
    }
}

