/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import android.gov.nist.javax.sip.SipStackImpl;
import android.gov.nist.javax.sip.message.SIPRequest;
import android.gov.nist.javax.sip.message.SIPResponse;
import android.gov.nist.javax.sip.stack.MessageChannel;
import android.gov.nist.javax.sip.stack.SIPMessageValve;
import android.javax.sip.SipStack;
import android.javax.sip.message.Response;
import java.io.IOException;

public class CongestionControlMessageValve
implements SIPMessageValve {
    private static StackLogger logger = CommonLogger.getLogger(CongestionControlMessageValve.class);
    protected SipStackImpl sipStack;
    protected int serverTransactionTableHighwaterMark;
    protected int dropResponseStatus;

    @Override
    public boolean processRequest(SIPRequest request, MessageChannel messageChannel) {
        boolean undropableMethod;
        String requestMethod = request.getMethod();
        boolean bl = undropableMethod = requestMethod.equals("BYE") || requestMethod.equals("ACK") || requestMethod.equals("PRACK") || requestMethod.equals("CANCEL");
        if (!undropableMethod && this.serverTransactionTableHighwaterMark <= this.sipStack.getServerTransactionTableSize()) {
            if (request.getToTag() != null) {
                return true;
            }
            if (this.dropResponseStatus > 0) {
                SIPResponse response = request.createResponse(this.dropResponseStatus);
                try {
                    messageChannel.sendMessage(response);
                }
                catch (IOException e) {
                    logger.logError("Failed to send congestion control error response" + response, e);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean processResponse(Response response, MessageChannel messageChannel) {
        return true;
    }

    @Override
    public void destroy() {
        logger.logInfo("Destorying the congestion control valve " + this);
    }

    @Override
    public void init(SipStack stack) {
        this.sipStack = (SipStackImpl)stack;
        logger.logInfo("Initializing congestion control valve");
        String serverTransactionsString = this.sipStack.getConfigurationProperties().getProperty("android.gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS", "10000");
        this.serverTransactionTableHighwaterMark = new Integer(serverTransactionsString);
        String dropResponseStatusString = this.sipStack.getConfigurationProperties().getProperty("DROP_RESPONSE_STATUS", "503");
        this.dropResponseStatus = new Integer(dropResponseStatusString);
    }
}

