/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class KeyedSemaphore {
    private final ConcurrentHashMap<String, ReentrantLock> map = new ConcurrentHashMap();
    private static final StackLogger logger = CommonLogger.getLogger(KeyedSemaphore.class);

    public void leaveIOCriticalSection(String key) {
        Lock creationLock = this.map.get(key);
        if (creationLock != null) {
            creationLock.unlock();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("sem unlocked:" + creationLock);
            }
        }
    }

    public void remove(String key) {
        ReentrantLock myLock = this.map.get(key);
        if (myLock != null && !myLock.hasQueuedThreads() && myLock.isHeldByCurrentThread()) {
            this.map.remove(key);
            logger.logDebug("sem removed:" + myLock);
            while (myLock.isHeldByCurrentThread() && myLock.getHoldCount() > 0) {
                logger.logDebug("unlocking after remove:" + myLock);
                myLock.unlock();
            }
        }
    }

    public void enterIOCriticalSection(String key) throws IOException {
        ReentrantLock newCreationLock;
        Lock creationLock = this.map.get(key);
        if (creationLock == null && (creationLock = (Lock)this.map.putIfAbsent(key, newCreationLock = new ReentrantLock(true))) == null) {
            creationLock = newCreationLock;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("new Semaphore added for key: " + key);
            }
        }
        try {
            boolean retval = creationLock.tryLock(10L, TimeUnit.SECONDS);
            if (!retval) {
                throw new IOException("Could not acquire IO Semaphore'" + key + "' after 10 seconds -- giving up ");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("exception in acquiring sem");
        }
    }

    public int getNumberOfSemaphores() {
        return this.map.size();
    }
}

