/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import android.gov.nist.javax.sip.header.CSeq;
import android.gov.nist.javax.sip.header.CallID;
import android.gov.nist.javax.sip.header.ContentLength;
import android.gov.nist.javax.sip.header.From;
import android.gov.nist.javax.sip.header.RequestLine;
import android.gov.nist.javax.sip.header.StatusLine;
import android.gov.nist.javax.sip.header.To;
import android.gov.nist.javax.sip.header.Via;
import android.gov.nist.javax.sip.message.SIPMessage;
import android.gov.nist.javax.sip.message.SIPRequest;
import android.gov.nist.javax.sip.message.SIPResponse;
import android.gov.nist.javax.sip.parser.NioPipelineParser;
import android.gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import android.gov.nist.javax.sip.stack.ConnectionOrientedMessageProcessor;
import android.gov.nist.javax.sip.stack.MessageChannel;
import android.gov.nist.javax.sip.stack.NIOHandler;
import android.gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import android.gov.nist.javax.sip.stack.SIPClientTransaction;
import android.gov.nist.javax.sip.stack.SIPTransaction;
import android.gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.text.ParseException;
import java.util.Queue;
import javax.net.ssl.SSLException;

public class NioTcpMessageChannel
extends ConnectionOrientedMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(NioTcpMessageChannel.class);
    protected SocketChannel socketChannel;
    protected long lastActivityTimeStamp;
    NioPipelineParser nioParser = null;
    private static final int BUF_SIZE = 4096;
    private final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4096);

    public void readChannel() {
        block12: {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("NioTcpMessageChannel::readChannel");
            }
            this.isRunning = true;
            try {
                boolean streamError;
                int nbytes = this.socketChannel.read(this.byteBuffer);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Read " + nbytes + " from socketChannel");
                }
                boolean bl = streamError = nbytes == -1;
                if (streamError) {
                    throw new IOException("End-of-stream read (-1). This is usually an indication we are stuck and it is better to disconnect.");
                }
                if (nbytes == 0) {
                    throw new IOException("The socket is giving us empty TCP packets. This is usually an indication we are stuck and it is better to disconnect.");
                }
                this.byteBuffer.flip();
                byte[] msg = new byte[this.byteBuffer.remaining()];
                this.byteBuffer.get(msg);
                this.byteBuffer.clear();
                this.addBytes(msg);
                this.lastActivityTimeStamp = System.currentTimeMillis();
            }
            catch (Exception ex) {
                if (ex instanceof IOException && !(ex instanceof SSLException)) {
                    try {
                        this.nioParser.addBytes("\r\n\r\n".getBytes("UTF-8"));
                    }
                    catch (Exception streamError) {
                        // empty catch block
                    }
                }
                try {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("I/O Issue closing sock " + ex.getMessage() + "myAddress:myport " + this.myAddress + ":" + this.myPort + ", remoteAddress:remotePort " + this.peerAddress + ":" + this.peerPort);
                        logger.logStackTrace();
                    }
                    this.close(true, false);
                }
                catch (Exception ex1) {
                    if (!logger.isLoggingEnabled(32)) break block12;
                    logger.logDebug("Issue closing the socket " + ex1);
                }
            }
        }
    }

    protected void addBytes(byte[] bytes) throws Exception {
        this.nioParser.addBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NioTcpMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        super(nioTcpMessageProcessor.getSIPStack());
        this.myClientInputStream = socketChannel.socket().getInputStream();
        try {
            this.peerAddress = socketChannel.socket().getInetAddress();
            this.peerPort = socketChannel.socket().getPort();
            this.socketChannel = socketChannel;
            this.mySock = socketChannel.socket();
            this.nioParser = new NioPipelineParser(this.sipStack, this, this.sipStack.getMaxMessageSize());
            this.peerProtocol = nioTcpMessageProcessor.transport;
            this.lastActivityTimeStamp = System.currentTimeMillis();
            this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, nioTcpMessageProcessor.transport);
            this.myAddress = nioTcpMessageProcessor.getIpAddress().getHostAddress();
            this.myPort = nioTcpMessageProcessor.getPort();
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Done creating NioTcpMessageChannel " + this + " socketChannel = " + socketChannel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioTcpMessageChannel(InetAddress inetAddress, int port, SIPTransactionStack sipStack, NioTcpMessageProcessor nioTcpMessageProcessor) throws IOException {
        super(sipStack);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("NioTcpMessageChannel::NioTcpMessageChannel: " + inetAddress.getHostAddress() + ":" + port);
        }
        try {
            this.messageProcessor = nioTcpMessageProcessor;
            this.socketChannel = nioTcpMessageProcessor.nioHandler.createOrReuseSocket(inetAddress, port);
            this.peerAddress = this.socketChannel.socket().getInetAddress();
            this.peerPort = this.socketChannel.socket().getPort();
            this.mySock = this.socketChannel.socket();
            this.peerProtocol = this.getTransport();
            this.nioParser = new NioPipelineParser(sipStack, this, this.sipStack.getMaxMessageSize());
            NIOHandler nioHandler = nioTcpMessageProcessor.nioHandler;
            nioHandler.putMessageChannel(this.socketChannel, this);
            this.lastActivityTimeStamp = System.currentTimeMillis();
            this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, this.getTransport());
            this.myAddress = nioTcpMessageProcessor.getIpAddress().getHostAddress();
            this.myPort = nioTcpMessageProcessor.getPort();
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("NioTcpMessageChannel::NioTcpMessageChannel: Done creating NioTcpMessageChannel " + this + " socketChannel = " + this.socketChannel);
            }
        }
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    protected void close(boolean removeSocket, boolean stopKeepAliveTask) {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing NioTcpMessageChannel " + this + " socketChannel = " + this.socketChannel);
            }
            NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
            nioHandler.removeMessageChannel(this.socketChannel);
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
            if (this.nioParser != null) {
                this.nioParser.close();
            }
            this.isRunning = false;
            if (removeSocket) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Removing NioTcpMessageChannel " + this + " socketChannel = " + this.socketChannel);
                }
                ((NioTcpMessageProcessor)this.messageProcessor).nioHandler.removeSocket(this.socketChannel);
                ((ConnectionOrientedMessageProcessor)this.messageProcessor).remove(this);
            }
            if (stopKeepAliveTask) {
                this.cancelPingKeepAliveTimeoutTaskIfStarted();
            }
        }
        catch (IOException e) {
            logger.logError("Problem occured while closing", e);
        }
    }

    @Override
    public String getTransport() {
        return this.messageProcessor.transport;
    }

    @Override
    protected void sendMessage(byte[] msg, boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient + " this = " + this);
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
        if (this.socketChannel != null && this.socketChannel.isConnected() && this.socketChannel.isOpen()) {
            nioHandler.putSocket(NIOHandler.makeKey(this.peerAddress, this.peerPort), this.socketChannel);
        }
        this.sendTCPMessage(msg, this.peerAddress, this.peerPort, isClient);
    }

    @Override
    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        this.sendTCPMessage(message, receiverAddress, receiverPort, retry);
    }

    public void sendTCPMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        NIOHandler nioHandler;
        SocketChannel sock;
        if (message == null || receiverAddress == null) {
            logger.logError("receiverAddress = " + receiverAddress);
            throw new IllegalArgumentException("Null argument");
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        if (this.peerPortAdvertisedInHeaders <= 0) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("receiver port = " + receiverPort + " for this channel " + this + " key " + this.key);
            }
            this.peerPortAdvertisedInHeaders = receiverPort <= 0 ? 5060 : receiverPort;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("2.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
            }
        }
        if ((sock = (nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler).sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, this.messageProcessor.transport, message, retry, this)) != this.socketChannel && sock != null) {
            if (this.socketChannel != null) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("[2] Old socket different than new socket on channel " + this.key + this.socketChannel + " " + sock);
                    logger.logStackTrace();
                    logger.logWarning("Old socket local ip address " + this.socketChannel.socket().getLocalSocketAddress());
                    logger.logWarning("Old socket remote ip address " + this.socketChannel.socket().getRemoteSocketAddress());
                    logger.logWarning("New socket local ip address " + sock.socket().getLocalSocketAddress());
                    logger.logWarning("New socket remote ip address " + sock.socket().getRemoteSocketAddress());
                }
                this.close(false, false);
                this.socketChannel = sock;
                nioHandler.putMessageChannel(this.socketChannel, this);
                this.onNewSocket(message);
            }
            if (this.socketChannel != null && logger.isLoggingEnabled(8)) {
                logger.logWarning("There was no exception for the retry mechanism so we keep going " + this.key);
            }
            this.socketChannel = sock;
        }
    }

    public void onNewSocket(byte[] message) {
    }

    @Override
    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Parsing Exception: ", ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            block7: {
                String msgString;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Encountered Bad Message \n" + sipMessage.toString());
                }
                if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ") && this.socketChannel != null) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("Malformed mandatory headers: closing socket! :" + this.socketChannel.toString());
                    }
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException ie) {
                        if (!logger.isLoggingEnabled(4)) break block7;
                        logger.logError("Exception while closing socket! :" + this.socketChannel.toString() + ":" + ie.toString());
                    }
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        NioTcpMessageChannel that = (NioTcpMessageChannel)other;
        return this.socketChannel == that.socketChannel;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public long getLastActivityTimestamp() {
        return this.lastActivityTimeStamp;
    }

    public void triggerConnectSuccess() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Connection Success. Nothing else to do.");
        }
    }

    public synchronized void triggerConnectFailure(Queue<NioTcpMessageProcessor.PendingData> failedMsgs) {
        while (failedMsgs != null && failedMsgs.peek() != null) {
            NioTcpMessageProcessor.PendingData pData = failedMsgs.poll();
            SIPTransaction transaction = this.sipStack.findTransaction(pData.txId, false);
            if (transaction == null) continue;
            if (transaction instanceof SIPClientTransaction) {
                if (transaction.getRequest() == null || transaction.getRequest().getMethod().equalsIgnoreCase("ACK")) continue;
                SIPRequest req = (SIPRequest)transaction.getRequest();
                SIPResponse unavRes = req.createResponse(503, "Transport error sending request.");
                try {
                    this.processMessage(unavRes);
                }
                catch (Exception e) {
                    if (!logger.isLoggingEnabled(32)) continue;
                    logger.logDebug("failed to report transport error", e);
                }
                continue;
            }
            transaction.raiseIOExceptionEvent();
        }
        this.close();
    }
}

