/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import android.gov.nist.javax.sip.SipStackImpl;
import android.gov.nist.javax.sip.message.SIPMessage;
import android.gov.nist.javax.sip.stack.ByteBufferFactory;
import android.gov.nist.javax.sip.stack.NIOHandler;
import android.gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import android.gov.nist.javax.sip.stack.NioTlsChannelInterface;
import android.gov.nist.javax.sip.stack.NioTlsWebSocketMessageProcessor;
import android.gov.nist.javax.sip.stack.NioWebSocketMessageChannel;
import android.gov.nist.javax.sip.stack.SIPTransactionStack;
import android.gov.nist.javax.sip.stack.SSLStateMachine;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;

public class NioTlsWebSocketMessageChannel
extends NioWebSocketMessageChannel
implements NioTlsChannelInterface {
    private static StackLogger logger = CommonLogger.getLogger(NioTlsWebSocketMessageChannel.class);
    SSLStateMachine sslStateMachine;
    private int appBufferMax;
    private int netBufferMax;

    protected NioTlsWebSocketMessageChannel(SIPTransactionStack stack, NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        super(stack, nioTcpMessageProcessor, socketChannel);
        this.messageProcessor = nioTcpMessageProcessor;
        this.myClientInputStream = socketChannel.socket().getInputStream();
        try {
            this.init(false);
            this.createBuffers();
        }
        catch (Exception e) {
            throw new IOException("Can't do TLS init", e);
        }
    }

    public void init(boolean clientMode) throws Exception, CertificateException, FileNotFoundException, IOException {
        Object[] ciphers;
        SSLContext ctx = clientMode ? ((NioTlsWebSocketMessageProcessor)this.messageProcessor).sslClientCtx : ((NioTlsWebSocketMessageProcessor)this.messageProcessor).sslServerCtx;
        this.sslStateMachine = new SSLStateMachine(ctx.createSSLEngine(), this);
        this.sslStateMachine.sslEngine.setUseClientMode(clientMode);
        String auth = ((SipStackImpl)this.sipStack).getConfigurationProperties().getProperty("android.gov.nist.javax.sip.TLS_CLIENT_AUTH_TYPE");
        this.sslStateMachine.sslEngine.setNeedClientAuth(false);
        this.sslStateMachine.sslEngine.setWantClientAuth(false);
        String clientProtocols = ((SipStackImpl)this.sipStack).getConfigurationProperties().getProperty("android.gov.nist.javax.sip.TLS_CLIENT_PROTOCOLS");
        if (clientProtocols != null) {
            this.sslStateMachine.sslEngine.setEnabledProtocols(clientProtocols.split(","));
        }
        if (!Arrays.equals(ciphers = ((SipStackImpl)this.sipStack).getEnabledCipherSuites(), SipStackImpl.DEFAULT_CIPHERS)) {
            logger.logDebug("Changing cipher suites");
            this.sslStateMachine.sslEngine.setEnabledCipherSuites((String[])ciphers);
        } else {
            logger.logDebug("JDK default ciphers will be used.");
        }
    }

    @Override
    public ByteBuffer prepareEncryptedDataBuffer() {
        return ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax);
    }

    @Override
    public ByteBuffer prepareAppDataBuffer() {
        return ByteBufferFactory.getInstance().allocateDirect(this.appBufferMax);
    }

    @Override
    public ByteBuffer prepareAppDataBuffer(int capacity) {
        return ByteBufferFactory.getInstance().allocateDirect(capacity);
    }

    @Override
    protected void sendMessage(byte[] msg, final boolean isClient) throws IOException {
        this.checkSocketState();
        if (this.client && this.readingHttp && this.httpClientRequestSent.compareAndSet(false, true)) {
            String http = "null null HTTP/1.1\r\nHost: null\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: dGhlIHNhbXBsZSBub25jZQ==\r\nSec-WebSocket-Protocol: sip\r\nSec-WebSocket-Version: 13\r\n\r\n";
            final ByteBuffer b1 = ByteBuffer.wrap(NioWebSocketMessageChannel.wrapBufferIntoWebSocketFrame(msg, this.client));
            ByteBuffer b = ByteBuffer.wrap("null null HTTP/1.1\r\nHost: null\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: dGhlIHNhbXBsZSBub25jZQ==\r\nSec-WebSocket-Protocol: sip\r\nSec-WebSocket-Version: 13\r\n\r\n".getBytes());
            this.sslStateMachine.wrap(b, ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

                @Override
                public void doSend(byte[] bytes) throws IOException {
                    NioTlsWebSocketMessageChannel.super.sendTCPMessage(bytes, NioTlsWebSocketMessageChannel.this.peerAddress, NioTlsWebSocketMessageChannel.this.peerPort, false);
                    Boolean sent = false;
                    try {
                        NioTlsWebSocketMessageChannel.this.sslStateMachine.wrap(b1, ByteBufferFactory.getInstance().allocateDirect(NioTlsWebSocketMessageChannel.this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

                            @Override
                            public void doSend(byte[] bytes) throws IOException {
                                NioTlsWebSocketMessageChannel.super.sendNonWebSocketMessage(bytes, isClient);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new IOException("Can't send message", e);
                    }
                }
            });
        }
        ByteBuffer b = ByteBuffer.wrap(NioWebSocketMessageChannel.wrapBufferIntoWebSocketFrame(msg, this.client));
        try {
            this.sslStateMachine.wrap(b, ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

                @Override
                public void doSend(byte[] bytes) throws IOException {
                    NioTlsWebSocketMessageChannel.super.sendNonWebSocketMessage(bytes, isClient);
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Can't send message", e);
        }
    }

    @Override
    public void sendEncryptedData(byte[] msg) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendEncryptedData  this = " + this + " peerPort = " + this.peerPort + " addr = " + this.peerAddress);
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
        if (this.socketChannel != null && this.socketChannel.isConnected() && this.socketChannel.isOpen()) {
            nioHandler.putSocket(NIOHandler.makeKey(this.peerAddress, this.peerPort), this.socketChannel);
        }
        super.sendNonWebSocketMessage(msg, false);
    }

    @Override
    public void sendMessage(byte[] message, final InetAddress receiverAddress, final int receiverPort, final boolean retry) throws IOException {
        this.checkSocketState();
        if (this.client && this.readingHttp && this.httpClientRequestSent.compareAndSet(false, true)) {
            String http = "null null HTTP/1.1\r\nHost: null\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: dGhlIHNhbXBsZSBub25jZQ==\r\nSec-WebSocket-Protocol: sip\r\nSec-WebSocket-Version: 13\r\n\r\n";
            final ByteBuffer b1 = ByteBuffer.wrap(NioWebSocketMessageChannel.wrapBufferIntoWebSocketFrame(message, this.client));
            ByteBuffer b = ByteBuffer.wrap("null null HTTP/1.1\r\nHost: null\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: dGhlIHNhbXBsZSBub25jZQ==\r\nSec-WebSocket-Protocol: sip\r\nSec-WebSocket-Version: 13\r\n\r\n".getBytes());
            this.sslStateMachine.wrap(b, ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

                @Override
                public void doSend(byte[] bytes) throws IOException {
                    NioTlsWebSocketMessageChannel.super.sendTCPMessage(bytes, receiverAddress, receiverPort, false);
                    NioTlsWebSocketMessageChannel.this.sslStateMachine.wrap(b1, ByteBufferFactory.getInstance().allocateDirect(NioTlsWebSocketMessageChannel.this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

                        @Override
                        public void doSend(byte[] bytes) throws IOException {
                            NioTlsWebSocketMessageChannel.super.sendTCPMessage(bytes, receiverAddress, receiverPort, retry);
                        }
                    });
                }
            });
        }
        ByteBuffer b = ByteBuffer.wrap(NioWebSocketMessageChannel.wrapBufferIntoWebSocketFrame(message, this.client));
        this.sslStateMachine.wrap(b, ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

            @Override
            public void doSend(byte[] bytes) throws IOException {
                NioTlsWebSocketMessageChannel.super.sendTCPMessage(bytes, receiverAddress, receiverPort, retry);
            }
        });
    }

    @Override
    public void sendMessage(SIPMessage sipMessage, InetAddress receiverAddress, int receiverPort) throws IOException {
        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
        this.sendMessage(msg, receiverAddress, receiverPort, this.client);
        if (logger.isLoggingEnabled(16)) {
            this.logMessage(sipMessage, receiverAddress, receiverPort, System.currentTimeMillis());
        }
    }

    public void sendHttpMessage(byte[] message, final InetAddress receiverAddress, final int receiverPort, final boolean retry) throws IOException {
        this.checkSocketState();
        ByteBuffer b = ByteBuffer.wrap(message);
        this.sslStateMachine.wrap(b, ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

            @Override
            public void doSend(byte[] bytes) throws IOException {
                NioTlsWebSocketMessageChannel.super.sendMessage(bytes, receiverAddress, receiverPort, retry);
            }
        });
    }

    private void createBuffers() {
        SSLSession session = this.sslStateMachine.sslEngine.getSession();
        this.appBufferMax = session.getApplicationBufferSize();
        this.netBufferMax = session.getPacketBufferSize();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("appBufferMax=" + this.appBufferMax + " netBufferMax=" + this.netBufferMax);
        }
    }

    public NioTlsWebSocketMessageChannel(InetAddress inetAddress, int port, SIPTransactionStack sipStack, NioTcpMessageProcessor nioTcpMessageProcessor) throws IOException {
        super(inetAddress, port, sipStack, nioTcpMessageProcessor);
        try {
            this.init(true);
            this.createBuffers();
        }
        catch (Exception e) {
            throw new IOException("Can't init the TLS channel", e);
        }
    }

    @Override
    protected void addBytes(byte[] bytes) throws Exception {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Adding WSS bytes for decryption " + bytes.length);
        }
        if (bytes.length <= 0) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.sslStateMachine.unwrap(buffer);
    }

    @Override
    protected void sendNonWebSocketMessage(byte[] msg, final boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient + " this = " + this);
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
        if (this.socketChannel != null && this.socketChannel.isConnected() && this.socketChannel.isOpen()) {
            nioHandler.putSocket(NIOHandler.makeKey(this.peerAddress, this.peerPort), this.socketChannel);
        }
        this.checkSocketState();
        ByteBuffer b = ByteBuffer.wrap(msg);
        this.sslStateMachine.wrap(b, ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

            @Override
            public void doSend(byte[] bytes) throws IOException {
                NioTlsWebSocketMessageChannel.super.sendTCPMessage(bytes, NioTlsWebSocketMessageChannel.this.peerAddress, NioTlsWebSocketMessageChannel.this.peerPort, isClient);
            }
        });
    }

    @Override
    public String getTransport() {
        return this.messageProcessor.transport;
    }

    @Override
    public void onNewSocket(byte[] message) {
        super.onNewSocket(message);
        try {
            if (logger.isLoggingEnabled(32)) {
                String last = null;
                if (message != null) {
                    last = new String(message, "UTF-8");
                }
                logger.logDebug("New socket for " + this + " last message = " + last);
            }
            this.init(true);
            this.createBuffers();
            this.sendMessage(message, false);
        }
        catch (Exception e) {
            logger.logError("Cant reinit", e);
        }
    }

    private void checkSocketState() throws IOException {
        if (!(this.socketChannel == null || this.socketChannel.isConnected() && this.socketChannel.isOpen())) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Need to reset SSL engine for socket " + this.socketChannel);
            }
            try {
                this.init(this.sslStateMachine.sslEngine.getUseClientMode());
            }
            catch (Exception ex) {
                logger.logError("Cannot reset SSL engine", ex);
                throw new IOException(ex);
            }
        }
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public void addPlaintextBytes(byte[] bytes) throws Exception {
        super.addBytes(bytes);
    }

    @Override
    public SipStackImpl getSIPStack() {
        return (SipStackImpl)super.getSIPStack();
    }

    public static class SSLReconnectedException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }
}

