/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import android.gov.nist.javax.sip.header.CSeq;
import android.gov.nist.javax.sip.header.CallID;
import android.gov.nist.javax.sip.header.ContentLength;
import android.gov.nist.javax.sip.header.From;
import android.gov.nist.javax.sip.header.RequestLine;
import android.gov.nist.javax.sip.header.StatusLine;
import android.gov.nist.javax.sip.header.To;
import android.gov.nist.javax.sip.header.Via;
import android.gov.nist.javax.sip.message.SIPMessage;
import android.gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import android.gov.nist.javax.sip.stack.MessageChannel;
import android.gov.nist.javax.sip.stack.SIPTransactionStack;
import android.gov.nist.javax.sip.stack.TCPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;

public class TCPMessageChannel
extends ConnectionOrientedMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(TCPMessageChannel.class);
    protected OutputStream myClientOutputStream;

    protected TCPMessageChannel(SIPTransactionStack sipStack) {
        super(sipStack);
    }

    protected TCPMessageChannel(Socket sock, SIPTransactionStack sipStack, TCPMessageProcessor msgProcessor, String threadName) throws IOException {
        super(sipStack);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("creating new TCPMessageChannel ");
            logger.logStackTrace();
        }
        this.mySock = sock;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = msgProcessor.getIpAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.myClientOutputStream = this.mySock.getOutputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName(threadName);
        this.peerPort = this.mySock.getPort();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        this.myPort = msgProcessor.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TCPMessageChannel(InetAddress inetAddr, int port, SIPTransactionStack sipStack, TCPMessageProcessor messageProcessor) throws IOException {
        super(sipStack);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("creating new TCPMessageChannel ");
            logger.logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TCP";
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        this.messageProcessor = messageProcessor;
    }

    @Override
    public void close(boolean removeSocket, boolean stopKeepAliveTask) {
        String ioHandlerKey;
        block17: {
            block16: {
                this.isRunning = false;
                if (this.mySock != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Closing socket " + this.key);
                    }
                    try {
                        this.mySock.close();
                        this.mySock = null;
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggingEnabled(32)) break block16;
                        logger.logDebug("Error closing socket " + ex);
                    }
                }
            }
            if (this.myParser != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Closing my parser " + this.myParser);
                }
                this.myParser.close();
            }
            if (this.myClientOutputStream != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Closing client output stream " + this.myClientOutputStream);
                }
                try {
                    this.myClientOutputStream.close();
                }
                catch (IOException ex) {
                    if (!logger.isLoggingEnabled(32)) break block17;
                    logger.logDebug("Error closing client output stream" + ex);
                }
            }
        }
        if (removeSocket) {
            ioHandlerKey = this.key.substring(4);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing TCP socket " + ioHandlerKey);
            }
            this.sipStack.ioHandler.removeSocket(ioHandlerKey);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing message Channel (key = " + this.key + ")" + this);
            }
        } else if (logger.isLoggingEnabled(32)) {
            ioHandlerKey = this.key.substring(4);
            logger.logDebug("not removing socket key from the cached map since it has already been updated by the iohandler.sendBytes " + ioHandlerKey);
        }
        if (stopKeepAliveTask) {
            this.cancelPingKeepAliveTimeoutTaskIfStarted();
        }
    }

    @Override
    public String getTransport() {
        return "TCP";
    }

    @Override
    protected synchronized void sendMessage(byte[] msg, boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient);
        }
        Socket sock = null;
        IOException problem = null;
        try {
            sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPort, this.peerProtocol, msg, isClient, this);
        }
        catch (IOException any) {
            problem = any;
            logger.logWarning("Failed to connect " + this.peerAddress + ":" + this.peerPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
        }
        if (sock == null) {
            if (this.peerAddressAdvertisedInHeaders != null && this.peerPortAdvertisedInHeaders > 0) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("Couldn't connect to peerAddress = " + this.peerAddress + " peerPort = " + this.peerPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                }
                InetAddress address = InetAddress.getByName(this.peerAddressAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), address, this.peerPortAdvertisedInHeaders, this.peerProtocol, msg, isClient, this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.peerAddress = address;
                this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("retry suceeded to peerAddress = " + this.peerAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
                }
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("Old socket different than new socket on channel " + this.key);
                    logger.logStackTrace();
                    logger.logWarning("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                    logger.logWarning("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                    logger.logWarning("New socket local ip address " + sock.getLocalSocketAddress());
                    logger.logWarning("New socket remote ip address " + sock.getRemoteSocketAddress());
                }
                this.close(false, false);
            }
            if (problem == null) {
                if (this.mySock != null && logger.isLoggingEnabled(8)) {
                    logger.logWarning("There was no exception for the retry mechanism so creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
                this.myClientInputStream = this.mySock.getInputStream();
                this.myClientOutputStream = this.mySock.getOutputStream();
                Thread thread = new Thread(this);
                thread.setDaemon(true);
                thread.setName("TCPMessageChannelThread");
                thread.start();
            } else {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("There was an exception for the retry mechanism so not creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
            }
        }
    }

    @Override
    public synchronized void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (this.peerPortAdvertisedInHeaders <= 0) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("receiver port = " + receiverPort + " for this channel " + this + " key " + this.key);
            }
            this.peerPortAdvertisedInHeaders = receiverPort <= 0 ? 5060 : receiverPort;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("2.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
            }
        }
        Socket sock = null;
        IOException problem = null;
        try {
            sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, "TCP", message, retry, this);
        }
        catch (IOException any) {
            problem = any;
            logger.logWarning("Failed to connect " + this.peerAddress + ":" + receiverPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
            logger.logError("Error is ", any);
        }
        if (sock == null) {
            if (this.peerAddressAdvertisedInHeaders != null && this.peerPortAdvertisedInHeaders > 0) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("Couldn't connect to receiverAddress = " + receiverAddress + " receiverPort = " + receiverPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                }
                InetAddress address = InetAddress.getByName(this.peerAddressAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), address, this.peerPortAdvertisedInHeaders, "TCP", message, retry, this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.peerAddress = address;
                this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("retry suceeded to peerAddress = " + this.peerAddress + " peerPort = " + this.peerPort + " key = " + this.key);
                }
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("Old socket different than new socket on channel " + this.key);
                    logger.logStackTrace();
                    logger.logWarning("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                    logger.logWarning("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                    logger.logWarning("New socket local ip address " + sock.getLocalSocketAddress());
                    logger.logWarning("New socket remote ip address " + sock.getRemoteSocketAddress());
                }
                this.close(false, false);
            }
            if (problem == null) {
                if (this.mySock != null && logger.isLoggingEnabled(8)) {
                    logger.logWarning("There was no exception for the retry mechanism so creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
                this.myClientInputStream = this.mySock.getInputStream();
                this.myClientOutputStream = this.mySock.getOutputStream();
                Thread mythread = new Thread(this);
                mythread.setDaemon(true);
                mythread.setName("TCPMessageChannelThread");
                mythread.start();
            } else {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("There was an exception for the retry mechanism so not creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
            }
        }
    }

    @Override
    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Parsing Exception: ", ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            block7: {
                String msgString;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Encountered Bad Message \n" + sipMessage.toString());
                }
                if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ") && this.mySock != null) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("Malformed mandatory headers: closing socket! :" + this.mySock.toString());
                    }
                    try {
                        this.mySock.close();
                    }
                    catch (IOException ie) {
                        if (!logger.isLoggingEnabled(4)) break block7;
                        logger.logError("Exception while closing socket! :" + this.mySock.toString() + ":" + ie.toString());
                    }
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TCPMessageChannel that = (TCPMessageChannel)other;
        return this.mySock == that.mySock;
    }

    @Override
    public boolean isSecure() {
        return false;
    }
}

