/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.StackLogger;
import android.gov.nist.javax.sip.stack.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class WebSocketHttpHandshake {
    private static StackLogger logger = CommonLogger.getLogger(WebSocketHttpHandshake.class);
    private HashMap<String, String> headers = new HashMap();

    public byte[] createHttpResponse(String request) throws Exception {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Request=" + request);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(request.getBytes());
        boolean isSecure = false;
        String line = this.readLine(is);
        if (line == null) {
            return null;
        }
        String[] parts = line.split(" ");
        if (parts.length >= 3) {
            this.headers.put("ctx", parts[1]);
        }
        while (!line.isEmpty()) {
            line = this.readLine(is);
            if (line == null || line.isEmpty() || (parts = line.split(":", 2)).length != 2) continue;
            if (parts[0].toLowerCase().startsWith("sec-websocket-key")) {
                isSecure = true;
            }
            this.headers.put(parts[0].trim(), parts[1].trim());
        }
        if (isSecure) {
            byte[] key3 = new byte[8];
            is.read(key3);
        }
        StringBuilder sb = new StringBuilder();
        String lineSeparator = "\r\n";
        sb.append("HTTP/1.1 101 Web Socket Protocol Handshake").append("\r\n");
        sb.append("Upgrade: WebSocket").append(lineSeparator);
        sb.append("Connection: Upgrade").append(lineSeparator);
        if (isSecure) {
            sb.append("Sec-");
        }
        sb.append("WebSocket-Origin: ").append(this.headers.get("Origin")).append(lineSeparator);
        if (isSecure) {
            sb.append("Sec-");
        }
        sb.append("WebSocket-Location: ws://").append(this.headers.get("Host")).append(this.headers.get("ctx")).append(lineSeparator);
        sb.append("Sec-WebSocket-Accept: ").append(WebSocketHttpHandshake.computeRev13Response(this.headers.get("Sec-WebSocket-Key"))).append(lineSeparator);
        if (this.headers.get("Protocol") != null) {
            if (isSecure) {
                sb.append("Sec-");
            }
            sb.append("Protocol: ").append(this.headers.get("Protocol")).append(lineSeparator);
        }
        if (this.headers.get("Sec-WebSocket-Protocol") != null) {
            sb.append("Sec-WebSocket-Protocol: ").append(this.headers.get("Sec-WebSocket-Protocol")).append(lineSeparator);
        }
        sb.append(lineSeparator);
        String response = sb.toString();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Response=" + response);
        }
        byte[] output = sb.toString().getBytes();
        return output;
    }

    public static String computeRev13Response(String key) throws IOException {
        key = key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
            md.reset();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        byte[] digest = md.digest(key.getBytes());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String encodeBase64String = Base64.encodeBytes(digest);
        return encodeBase64String;
    }

    private String readLine(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        int cr = 13;
        int nl = 10;
        boolean gotcr = false;
        while (true) {
            int input;
            if ((input = is.read()) == -1) {
                return null;
            }
            if (input == cr) {
                gotcr = true;
                continue;
            }
            if (input == nl && gotcr) break;
            if (input == nl) {
                return null;
            }
            sb.append((char)input);
        }
        return sb.toString();
    }
}

