/*
 * Decompiled with CFR 0.152.
 */
package android.gov.nist.javax.sip.stack.timers;

import android.gov.nist.core.CommonLogger;
import android.gov.nist.core.NamingThreadFactory;
import android.gov.nist.core.StackLogger;
import android.gov.nist.javax.sip.SipStackImpl;
import android.gov.nist.javax.sip.stack.SIPStackTimerTask;
import android.gov.nist.javax.sip.stack.timers.SipTimer;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorSipTimer
implements SipTimer {
    private static StackLogger logger = CommonLogger.getLogger(ScheduledExecutorSipTimer.class);
    protected SipStackImpl sipStackImpl;
    ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(1, new NamingThreadFactory("jain_sip_timer_executor"));

    private void schedulePurgeTaskIfNeeded() {
        int purgePeriod = Integer.parseInt(this.sipStackImpl.getConfigurationProperties().getProperty("android.gov.nist.javax.sip.timers.SCHEDULED_EXECUTOR_PURGE_DELAY", "1"));
        if (purgePeriod > 0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Purging canceled timer tasks...");
                        }
                        ScheduledExecutorSipTimer.this.threadPoolExecutor.purge();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Purging canceled timer tasks completed.");
                        }
                    }
                    catch (Exception e) {
                        logger.logError("failed to execute purge", e);
                    }
                }
            };
            this.threadPoolExecutor.scheduleWithFixedDelay(r, purgePeriod, purgePeriod, TimeUnit.MINUTES);
        }
    }

    @Override
    public void stop() {
        this.threadPoolExecutor.shutdown();
        logger.logStackTrace(32);
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been stopped");
        }
    }

    @Override
    public boolean schedule(SIPStackTimerTask task, long delay) {
        if (this.threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        ScheduledFuture<?> future = this.threadPoolExecutor.schedule(new ScheduledSipTimerTask(task), delay, TimeUnit.MILLISECONDS);
        task.setSipTimerTask(future);
        return true;
    }

    @Override
    public boolean scheduleWithFixedDelay(SIPStackTimerTask task, long delay, long period) {
        if (this.threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        ScheduledFuture<?> future = this.threadPoolExecutor.scheduleWithFixedDelay(new ScheduledSipTimerTask(task), delay, period, TimeUnit.MILLISECONDS);
        task.setSipTimerTask(future);
        return true;
    }

    @Override
    public void start(SipStackImpl sipStack, Properties configurationProperties) {
        this.sipStackImpl = sipStack;
        this.threadPoolExecutor.prestartAllCoreThreads();
        this.schedulePurgeTaskIfNeeded();
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been started");
        }
    }

    @Override
    public boolean cancel(SIPStackTimerTask task) {
        boolean cancelled = false;
        ScheduledFuture sipTimerTask = (ScheduledFuture)task.getSipTimerTask();
        if (sipTimerTask != null) {
            task.cleanUpBeforeCancel();
            task.setSipTimerTask(null);
            this.threadPoolExecutor.remove((Runnable)((Object)sipTimerTask));
            cancelled = sipTimerTask.cancel(false);
        }
        return cancelled;
    }

    @Override
    public boolean isStarted() {
        return !this.threadPoolExecutor.isShutdown();
    }

    private class ScheduledSipTimerTask
    implements Runnable {
        private SIPStackTimerTask task;

        public ScheduledSipTimerTask(SIPStackTimerTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (this.task != null) {
                    this.task.runTask();
                }
            }
            catch (Throwable e) {
                System.out.println("SIP stack timer task failed due to exception:");
                e.printStackTrace();
            }
        }
    }
}

