/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.clientauthutils;

import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.sip.header.AuthorizationHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CredentialsCache {
    private Hashtable<String, Hashtable<String, List<AuthorizationHeader>>> authenticatedCalls = new Hashtable();

    CredentialsCache() {
    }

    void cacheAuthorizationHeader(String proxyDomain, AuthorizationHeader authorization) {
        String user = authorization.getUsername();
        assert (proxyDomain != null);
        Hashtable<String, List<Object>> authHeaders = this.authenticatedCalls.get(proxyDomain);
        if (authHeaders == null) {
            authHeaders = new Hashtable();
            this.authenticatedCalls.put(proxyDomain, authHeaders);
        }
        LinkedList<AuthorizationHeader> alist = new LinkedList<AuthorizationHeader>();
        authHeaders.put(user, alist);
        alist.add(authorization);
    }

    Collection<AuthorizationHeader> getCachedAuthorizationHeaders(String proxyDomain, String user) {
        if (user == null) {
            throw new NullPointerException("Null arg!");
        }
        Hashtable<String, List<AuthorizationHeader>> authHeaderMap = this.authenticatedCalls.get(proxyDomain);
        if (authHeaderMap == null) {
            return null;
        }
        return authHeaderMap.get(user);
    }
}

