/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.SIPObject;

public class RequestLine
extends SIPObject {
    private static final long serialVersionUID = -3286426172326043129L;
    protected GenericURI uri;
    protected String method;
    protected String sipVersion;

    public RequestLine() {
        this.sipVersion = "SIP/2.0";
    }

    public void setSIPVersion(String sipVersion) {
        this.sipVersion = sipVersion;
    }

    public String encode() {
        return this.encode(new StringBuffer()).toString();
    }

    public StringBuffer encode(StringBuffer buffer) {
        if (this.method != null) {
            buffer.append(this.method);
            buffer.append(" ");
        }
        if (this.uri != null) {
            this.uri.encode(buffer);
            buffer.append(" ");
        }
        buffer.append(this.sipVersion);
        buffer.append("\r\n");
        return buffer;
    }

    public GenericURI getUri() {
        return this.uri;
    }

    public RequestLine(GenericURI requestURI, String method) {
        this.uri = requestURI;
        this.method = method;
        this.sipVersion = "SIP/2.0";
    }

    public String getMethod() {
        return this.method;
    }

    public String getSipVersion() {
        return this.sipVersion;
    }

    public void setUri(GenericURI uri) {
        this.uri = uri;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setSipVersion(String s) {
        this.sipVersion = s;
    }

    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String major = null;
        boolean slash = false;
        for (int i = 0; i < this.sipVersion.length() && this.sipVersion.charAt(i) != '.'; ++i) {
            if (slash) {
                major = major == null ? "" + this.sipVersion.charAt(i) : major + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '/') continue;
            slash = true;
        }
        return major;
    }

    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String minor = null;
        boolean dot = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (dot) {
                minor = minor == null ? "" + this.sipVersion.charAt(i) : minor + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '.') continue;
            dot = true;
        }
        return minor;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        RequestLine that = (RequestLine)other;
        try {
            retval = this.method.equals(that.method) && this.uri.equals(that.uri) && this.sipVersion.equals(that.sipVersion);
        }
        catch (NullPointerException ex) {
            retval = false;
        }
        return retval;
    }

    public Object clone() {
        RequestLine retval = (RequestLine)super.clone();
        if (this.uri != null) {
            retval.uri = (GenericURI)this.uri.clone();
        }
        return retval;
    }
}

