/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.ims;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.ims.PChargingFunctionAddressesHeader;
import gov.nist.javax.sip.header.ims.SIPHeaderNamesIms;
import java.text.ParseException;
import java.util.Iterator;
import java.util.ListIterator;
import javax.sip.header.ExtensionHeader;

public class PChargingFunctionAddresses
extends ParametersHeader
implements PChargingFunctionAddressesHeader,
SIPHeaderNamesIms,
ExtensionHeader {
    public PChargingFunctionAddresses() {
        super("P-Charging-Function-Addresses");
    }

    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        if (!this.parameters.isEmpty()) {
            encoding.append(this.parameters.encode());
        }
        return encoding.toString();
    }

    public void setChargingCollectionFunctionAddress(String ccfAddress) throws ParseException {
        if (ccfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setChargingCollectionFunctionAddress(), the ccfAddress parameter is null.");
        }
        this.setParameter("ccf", ccfAddress);
    }

    public void addChargingCollectionFunctionAddress(String ccfAddress) throws ParseException {
        if (ccfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setChargingCollectionFunctionAddress(), the ccfAddress parameter is null.");
        }
        this.parameters.set("ccf", ccfAddress);
    }

    public void removeChargingCollectionFunctionAddress(String ccfAddress) throws ParseException {
        if (ccfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setChargingCollectionFunctionAddress(), the ccfAddress parameter is null.");
        }
        if (!this.delete(ccfAddress, "ccf")) {
            throw new ParseException("CCF Address Not Removed", 0);
        }
    }

    public ListIterator getChargingCollectionFunctionAddresses() {
        Iterator<NameValue> li = this.parameters.iterator();
        ListIterator ccfLIST = null;
        while (li.hasNext()) {
            NameValue nv = li.next();
            if (!nv.getName().equalsIgnoreCase("ccf")) continue;
            NameValue ccfNV = new NameValue();
            ccfNV.setName(nv.getName());
            ccfNV.setValueAsObject(nv.getValueAsObject());
            ccfLIST.add(ccfNV);
        }
        return ccfLIST;
    }

    public void setEventChargingFunctionAddress(String ecfAddress) throws ParseException {
        if (ecfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setEventChargingFunctionAddress(), the ecfAddress parameter is null.");
        }
        this.setParameter("ecf", ecfAddress);
    }

    public void addEventChargingFunctionAddress(String ecfAddress) throws ParseException {
        if (ecfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setEventChargingFunctionAddress(), the ecfAddress parameter is null.");
        }
        this.parameters.set("ecf", ecfAddress);
    }

    public void removeEventChargingFunctionAddress(String ecfAddress) throws ParseException {
        if (ecfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setEventChargingFunctionAddress(), the ecfAddress parameter is null.");
        }
        if (!this.delete(ecfAddress, "ecf")) {
            throw new ParseException("ECF Address Not Removed", 0);
        }
    }

    public ListIterator getEventChargingFunctionAddresses() {
        Iterator<NameValue> li = this.parameters.iterator();
        ListIterator ecfLIST = null;
        boolean removed = false;
        while (li.hasNext()) {
            NameValue nv = li.next();
            if (!nv.getName().equalsIgnoreCase("ecf")) continue;
            NameValue ecfNV = new NameValue();
            ecfNV.setName(nv.getName());
            ecfNV.setValueAsObject(nv.getValueAsObject());
            ecfLIST.add(ecfNV);
        }
        return ecfLIST;
    }

    public boolean delete(String value, String name) {
        Iterator<NameValue> li = this.parameters.iterator();
        boolean removed = false;
        while (li.hasNext()) {
            NameValue nv = li.next();
            if (!((String)nv.getValueAsObject()).equalsIgnoreCase(value) || !nv.getName().equalsIgnoreCase(name)) continue;
            li.remove();
            removed = true;
        }
        return removed;
    }

    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }
}

