/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.ims;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.ims.PAssertedServiceHeader;
import gov.nist.javax.sip.header.ims.SIPHeaderNamesIms;
import java.text.ParseException;
import javax.sip.header.ExtensionHeader;

public class PAssertedService
extends SIPHeader
implements PAssertedServiceHeader,
SIPHeaderNamesIms,
ExtensionHeader {
    private String subServiceIds;
    private String subAppIds;

    protected PAssertedService(String name) {
        super("P-Asserted-Service");
    }

    public PAssertedService() {
        super("P-Asserted-Service");
    }

    protected String encodeBody() {
        StringBuffer retval = new StringBuffer();
        retval.append("urn:urn-7:");
        if (this.subServiceIds != null) {
            retval.append("3gpp-service").append(".");
            retval.append(this.getSubserviceIdentifiers());
        } else if (this.subAppIds != null) {
            retval.append("3gpp-application").append(".");
            retval.append(this.getApplicationIdentifiers());
        }
        return retval.toString();
    }

    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }

    public String getApplicationIdentifiers() {
        if (this.subAppIds.charAt(0) == '.') {
            return this.subAppIds.substring(1);
        }
        return this.subAppIds;
    }

    public String getSubserviceIdentifiers() {
        if (this.subServiceIds.charAt(0) == '.') {
            return this.subServiceIds.substring(1);
        }
        return this.subServiceIds;
    }

    public void setApplicationIdentifiers(String appids) {
        this.subAppIds = appids;
    }

    public void setSubserviceIdentifiers(String subservices) {
        this.subServiceIds = subservices;
    }

    public boolean equals(Object other) {
        return other instanceof PAssertedServiceHeader && super.equals(other);
    }

    public Object clone() {
        PAssertedService retval = (PAssertedService)super.clone();
        return retval;
    }
}

