/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.ims;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.ims.PChargingVectorHeader;
import gov.nist.javax.sip.header.ims.SIPHeaderNamesIms;
import java.text.ParseException;
import javax.sip.header.ExtensionHeader;

public class PChargingVector
extends ParametersHeader
implements PChargingVectorHeader,
SIPHeaderNamesIms,
ExtensionHeader {
    public PChargingVector() {
        super("P-Charging-Vector");
    }

    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        NameValue nv = this.getNameValue("icid-value");
        nv.encode(encoding);
        if (this.parameters.containsKey("icid-generated-at")) {
            encoding.append(";").append("icid-generated-at").append("=").append(this.getICIDGeneratedAt());
        }
        if (this.parameters.containsKey("term-ioi")) {
            encoding.append(";").append("term-ioi").append("=").append(this.getTerminatingIOI());
        }
        if (this.parameters.containsKey("orig-ioi")) {
            encoding.append(";").append("orig-ioi").append("=").append(this.getOriginatingIOI());
        }
        return encoding.toString();
    }

    public String getICID() {
        return this.getParameter("icid-value");
    }

    public void setICID(String icid) throws ParseException {
        if (icid == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Vector, setICID(), the icid parameter is null.");
        }
        this.setParameter("icid-value", icid);
    }

    public String getICIDGeneratedAt() {
        return this.getParameter("icid-generated-at");
    }

    public void setICIDGeneratedAt(String host) throws ParseException {
        if (host == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Vector, setICIDGeneratedAt(), the host parameter is null.");
        }
        this.setParameter("icid-generated-at", host);
    }

    public String getOriginatingIOI() {
        return this.getParameter("orig-ioi");
    }

    public void setOriginatingIOI(String origIOI) throws ParseException {
        if (origIOI == null || origIOI.length() == 0) {
            this.removeParameter("orig-ioi");
        } else {
            this.setParameter("orig-ioi", origIOI);
        }
    }

    public String getTerminatingIOI() {
        return this.getParameter("term-ioi");
    }

    public void setTerminatingIOI(String termIOI) throws ParseException {
        if (termIOI == null || termIOI.length() == 0) {
            this.removeParameter("term-ioi");
        } else {
            this.setParameter("term-ioi", termIOI);
        }
    }

    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }
}

