/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.core.Token;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelURLImpl;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.Parser;
import java.text.ParseException;

public class URLParser
extends Parser {
    public URLParser(String url) {
        this.lexer = new Lexer("sip_urlLexer", url);
    }

    public URLParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("sip_urlLexer");
    }

    protected static boolean isMark(char next) {
        switch (next) {
            case '!': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isUnreserved(char next) {
        return Lexer.isAlphaDigit(next) || URLParser.isMark(next);
    }

    protected static boolean isReservedNoSlash(char next) {
        switch (next) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case ':': 
            case ';': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isUserUnreserved(char la) {
        switch (la) {
            case '#': 
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ';': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    protected String unreserved() throws ParseException {
        char next = this.lexer.lookAhead(0);
        if (URLParser.isUnreserved(next)) {
            this.lexer.consume(1);
            return String.valueOf(next);
        }
        throw this.createParseException("unreserved");
    }

    protected String paramNameOrValue() throws ParseException {
        int startIdx = this.lexer.getPtr();
        while (this.lexer.hasMoreChars()) {
            char next = this.lexer.lookAhead(0);
            boolean isValidChar = false;
            switch (next) {
                case '$': 
                case '&': 
                case '+': 
                case '/': 
                case ':': 
                case '[': 
                case ']': {
                    isValidChar = true;
                }
            }
            if (isValidChar || URLParser.isUnreserved(next)) {
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            this.lexer.consume(3);
        }
        return this.lexer.getBuffer().substring(startIdx, this.lexer.getPtr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameValue uriParam() throws ParseException {
        boolean isFlagParam;
        String pname;
        String pvalue;
        block4: {
            try {
                pvalue = "";
                pname = this.paramNameOrValue();
                char next = this.lexer.lookAhead(0);
                isFlagParam = true;
                if (next == '=') {
                    this.lexer.consume(1);
                    pvalue = this.paramNameOrValue();
                    isFlagParam = false;
                }
                if (pname.length() != 0 || pvalue != null && pvalue.length() != 0) break block4;
                NameValue nameValue = null;
                Object var7_7 = null;
                return nameValue;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                throw throwable;
            }
        }
        NameValue nameValue = new NameValue(pname, pvalue, isFlagParam);
        Object var7_8 = null;
        return nameValue;
    }

    protected static boolean isReserved(char next) {
        switch (next) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    protected String reserved() throws ParseException {
        char next = this.lexer.lookAhead(0);
        if (URLParser.isReserved(next)) {
            this.lexer.consume(1);
            return new StringBuffer().append(next).toString();
        }
        throw this.createParseException("reserved");
    }

    protected boolean isEscaped() {
        try {
            return this.lexer.lookAhead(0) == '%' && Lexer.isHexDigit(this.lexer.lookAhead(1)) && Lexer.isHexDigit(this.lexer.lookAhead(2));
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String escaped() throws ParseException {
        try {
            StringBuffer retval = new StringBuffer();
            char next = this.lexer.lookAhead(0);
            char next1 = this.lexer.lookAhead(1);
            char next2 = this.lexer.lookAhead(2);
            if (next != '%' || !Lexer.isHexDigit(next1) || !Lexer.isHexDigit(next2)) {
                throw this.createParseException("escaped");
            }
            this.lexer.consume(3);
            retval.append(next);
            retval.append(next1);
            retval.append(next2);
            String string = retval.toString();
            Object var7_6 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    protected String mark() throws ParseException {
        block3: {
            try {
                char next = this.lexer.lookAhead(0);
                if (!URLParser.isMark(next)) break block3;
                this.lexer.consume(1);
                String string = new String(new char[]{next});
                Object var4_3 = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        throw this.createParseException("mark");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String uric() {
        try {
            block9: {
                block8: {
                    char la;
                    block7: {
                        try {
                            la = this.lexer.lookAhead(0);
                            if (!URLParser.isUnreserved(la)) break block7;
                            this.lexer.consume(1);
                            return Lexer.charAsString(la);
                        }
                        catch (Exception ex) {
                            return null;
                        }
                    }
                    if (!URLParser.isReserved(la)) break block8;
                    this.lexer.consume(1);
                    return Lexer.charAsString(la);
                }
                if (!this.isEscaped()) break block9;
                String retval = this.lexer.charAsString(3);
                this.lexer.consume(3);
                return retval;
            }
            return null;
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String uricNoSlash() {
        try {
            block9: {
                char la;
                block8: {
                    block7: {
                        try {
                            la = this.lexer.lookAhead(0);
                            if (!this.isEscaped()) break block7;
                            String retval = this.lexer.charAsString(3);
                            this.lexer.consume(3);
                            return retval;
                        }
                        catch (ParseException ex) {
                            return null;
                        }
                    }
                    if (!URLParser.isUnreserved(la)) break block8;
                    this.lexer.consume(1);
                    return Lexer.charAsString(la);
                }
                if (!URLParser.isReservedNoSlash(la)) break block9;
                this.lexer.consume(1);
                return Lexer.charAsString(la);
            }
            return null;
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            throw throwable;
        }
    }

    protected String uricString() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (true) {
            String next;
            if ((next = this.uric()) == null) {
                char la = this.lexer.lookAhead(0);
                if (la != '[') break;
                HostNameParser hnp = new HostNameParser(this.getLexer());
                HostPort hp = hnp.hostPort(false);
                retval.append(hp.toString());
                continue;
            }
            retval.append(next);
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GenericURI uriReference() throws ParseException {
        Object var1_1 = null;
        Token[] tokens = this.lexer.peekNextToken(2);
        Token t1 = tokens[0];
        Token t2 = tokens[1];
        try {
            void var1_5;
            if (t1.getTokenType() == 2051 || t1.getTokenType() == 2136) {
                if (t2.getTokenType() != 58) throw this.createParseException("Expecting ':'");
                SipUri sipUri = this.sipURL();
            } else if (t1.getTokenType() == 2105) {
                if (t2.getTokenType() != 58) throw this.createParseException("Expecting ':'");
                TelURLImpl telURLImpl = this.telURL();
            } else {
                String urlString = this.uricString();
                try {
                    GenericURI genericURI = new GenericURI(urlString);
                }
                catch (ParseException ex) {
                    throw this.createParseException(ex.getMessage());
                }
            }
            Object var8_11 = null;
            return var1_5;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String base_phone_number() throws ParseException {
        StringBuffer s = new StringBuffer();
        try {
            int lc = 0;
            while (this.lexer.hasMoreChars()) {
                char w = this.lexer.lookAhead(0);
                if (Lexer.isDigit(w) || w == '-' || w == '.' || w == '(' || w == ')') {
                    this.lexer.consume(1);
                    s.append(w);
                    ++lc;
                    continue;
                }
                if (lc > 0) break;
                throw this.createParseException("unexpected " + w);
            }
            String string = s.toString();
            Object var5_5 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String local_number() throws ParseException {
        StringBuffer s = new StringBuffer();
        try {
            int lc = 0;
            while (this.lexer.hasMoreChars()) {
                char la = this.lexer.lookAhead(0);
                if (la == '*' || la == '#' || la == '-' || la == '.' || la == '(' || la == ')' || Lexer.isHexDigit(la)) {
                    this.lexer.consume(1);
                    s.append(la);
                    ++lc;
                    continue;
                }
                if (lc > 0) break;
                throw this.createParseException("unexepcted " + la);
            }
            String string = s.toString();
            Object var5_5 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TelephoneNumber parseTelephoneNumber() throws ParseException {
        this.lexer.selectLexer("charLexer");
        try {
            TelephoneNumber tn;
            char c = this.lexer.lookAhead(0);
            if (c == '+') {
                tn = this.global_phone_number();
            } else if (Lexer.isHexDigit(c) || c == '#' || c == '*' || c == '-' || c == '.' || c == '(' || c == ')') {
                tn = this.local_phone_number();
            } else {
                throw this.createParseException("unexpected char " + c);
            }
            TelephoneNumber telephoneNumber = tn;
            Object var5_4 = null;
            return telephoneNumber;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TelephoneNumber global_phone_number() throws ParseException {
        try {
            char tok;
            TelephoneNumber tn = new TelephoneNumber();
            tn.setGlobal(true);
            NameValueList nv = null;
            this.lexer.match(43);
            String b = this.base_phone_number();
            tn.setPhoneNumber(b);
            if (this.lexer.hasMoreChars() && (tok = this.lexer.lookAhead(0)) == ';') {
                this.lexer.consume(1);
                nv = this.tel_parameters();
                tn.setParameters(nv);
            }
            TelephoneNumber telephoneNumber = tn;
            Object var6_6 = null;
            return telephoneNumber;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TelephoneNumber local_phone_number() throws ParseException {
        TelephoneNumber tn = new TelephoneNumber();
        tn.setGlobal(false);
        NameValueList nv = null;
        String b = null;
        try {
            b = this.local_number();
            tn.setPhoneNumber(b);
            if (this.lexer.hasMoreChars()) {
                Token tok = this.lexer.peekNextToken();
                switch (tok.getTokenType()) {
                    case 59: {
                        this.lexer.consume(1);
                        nv = this.tel_parameters();
                        tn.setParameters(nv);
                        break;
                    }
                }
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
        return tn;
    }

    private NameValueList tel_parameters() throws ParseException {
        NameValueList nvList = new NameValueList();
        while (true) {
            NameValue nv;
            String pname;
            if ((pname = this.paramNameOrValue()).equalsIgnoreCase("phone-context")) {
                nv = this.phone_context();
            } else if (this.lexer.lookAhead(0) == '=') {
                this.lexer.consume(1);
                String value = this.paramNameOrValue();
                nv = new NameValue(pname, value, false);
            } else {
                nv = new NameValue(pname, "", true);
            }
            nvList.set(nv);
            if (this.lexer.lookAhead(0) != ';') break;
            this.lexer.consume(1);
        }
        return nvList;
    }

    private NameValue phone_context() throws ParseException {
        String value;
        this.lexer.match(61);
        char la = this.lexer.lookAhead(0);
        if (la == '+') {
            this.lexer.consume(1);
            value = "+" + this.base_phone_number();
        } else if (Lexer.isAlphaDigit(la)) {
            Token t = this.lexer.match(4095);
            value = t.getTokenValue();
        } else {
            throw new ParseException("Invalid phone-context:" + la, -1);
        }
        return new NameValue("phone-context", value, false);
    }

    public TelURLImpl telURL() throws ParseException {
        this.lexer.match(2105);
        this.lexer.match(58);
        TelephoneNumber tn = this.parseTelephoneNumber();
        TelURLImpl telUrl = new TelURLImpl();
        telUrl.setTelephoneNumber(tn);
        return telUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipUri sipURL() throws ParseException {
        SipUri retval = new SipUri();
        Token nextToken = this.lexer.peekNextToken();
        int sipOrSips = 2051;
        String scheme = "sip";
        if (nextToken.getTokenType() == 2136) {
            sipOrSips = 2136;
            scheme = "sips";
        }
        try {
            NameValue parms;
            this.lexer.match(sipOrSips);
            this.lexer.match(58);
            retval.setScheme(scheme);
            int startOfUser = this.lexer.markInputPosition();
            String userOrHost = this.user();
            String passOrPort = null;
            if (this.lexer.lookAhead() == ':') {
                this.lexer.consume(1);
                passOrPort = this.password();
            }
            if (this.lexer.lookAhead() == '@') {
                this.lexer.consume(1);
                retval.setUser(userOrHost);
                if (passOrPort != null) {
                    retval.setUserPassword(passOrPort);
                }
            } else {
                this.lexer.rewindInputPosition(startOfUser);
            }
            HostNameParser hnp = new HostNameParser(this.getLexer());
            HostPort hp = hnp.hostPort(false);
            retval.setHostPort(hp);
            this.lexer.selectLexer("charLexer");
            while (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == ';') {
                this.lexer.consume(1);
                parms = this.uriParam();
                if (parms == null) continue;
                retval.setUriParameter(parms);
            }
            if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == '?') {
                this.lexer.consume(1);
                while (this.lexer.hasMoreChars()) {
                    parms = this.qheader();
                    retval.setQHeader(parms);
                    if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) != '&') break;
                    this.lexer.consume(1);
                }
            }
            SipUri sipUri = retval;
            Object var12_11 = null;
            return sipUri;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            throw throwable;
        }
    }

    public String peekScheme() throws ParseException {
        Token[] tokens = this.lexer.peekNextToken(1);
        if (tokens.length == 0) {
            return null;
        }
        String scheme = tokens[0].getTokenValue();
        return scheme;
    }

    protected NameValue qheader() throws ParseException {
        String name = this.lexer.getNextToken('=');
        this.lexer.consume(1);
        String value = this.hvalue();
        return new NameValue(name, value, false);
    }

    protected String hvalue() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            boolean isValidChar = false;
            switch (la) {
                case '!': 
                case '\"': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case ']': 
                case '_': 
                case '~': {
                    isValidChar = true;
                }
            }
            if (isValidChar || Lexer.isAlphaDigit(la)) {
                this.lexer.consume(1);
                retval.append(la);
                continue;
            }
            if (la != '%') break;
            retval.append(this.escaped());
        }
        return retval.toString();
    }

    protected String urlString() throws ParseException {
        char la;
        StringBuffer retval = new StringBuffer();
        this.lexer.selectLexer("charLexer");
        while (this.lexer.hasMoreChars() && (la = this.lexer.lookAhead(0)) != ' ' && la != '\t' && la != '\n' && la != '>' && la != '<') {
            this.lexer.consume(0);
            retval.append(la);
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String user() throws ParseException {
        try {
            int startIdx = this.lexer.getPtr();
            while (this.lexer.hasMoreChars()) {
                char la = this.lexer.lookAhead(0);
                if (URLParser.isUnreserved(la) || URLParser.isUserUnreserved(la)) {
                    this.lexer.consume(1);
                    continue;
                }
                if (!this.isEscaped()) break;
                this.lexer.consume(3);
            }
            String string = this.lexer.getBuffer().substring(startIdx, this.lexer.getPtr());
            Object var4_4 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            throw throwable;
        }
    }

    protected String password() throws ParseException {
        int startIdx = this.lexer.getPtr();
        while (true) {
            char la = this.lexer.lookAhead(0);
            boolean isValidChar = false;
            switch (la) {
                case '$': 
                case '&': 
                case '+': 
                case ',': 
                case '=': {
                    isValidChar = true;
                }
            }
            if (isValidChar || URLParser.isUnreserved(la)) {
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            this.lexer.consume(3);
        }
        return this.lexer.getBuffer().substring(startIdx, this.lexer.getPtr());
    }

    public GenericURI parse() throws ParseException {
        return this.uriReference();
    }

    public static void main(String[] args) throws ParseException {
        String[] test = new String[]{"sip:alice@example.com", "sips:alice@examples.com", "sip:3Zqkv5dajqaaas0tCjCxT0xH2ZEuEMsFl0xoasip%3A%2B3519116786244%40siplab.domain.com@213.0.115.163:7070"};
        for (int i = 0; i < test.length; ++i) {
            URLParser p = new URLParser(test[i]);
            GenericURI uri = p.parse();
            System.out.println("uri type returned " + uri.getClass().getName());
            System.out.println(test[i] + " is SipUri? " + uri.isSipURI() + ">" + uri.encode());
        }
    }
}

